/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.translator.ir.instr;

import com.sun.squawk.translator.ir.Instruction;
import com.sun.squawk.translator.ir.OperandVisitor;
import com.sun.squawk.translator.ir.Target;
import com.sun.squawk.translator.ir.instr.StackProducer;

public abstract class Switch
extends Instruction {
    private StackProducer key;
    private final Target[] targets;
    private final Target defaultTarget;
    private int padding;

    public Switch(StackProducer key, int targetsCount, Target defaultTarget) {
        this.key = key;
        this.targets = new Target[targetsCount];
        this.defaultTarget = defaultTarget;
    }

    protected void addTarget(int index, Target target) {
        this.targets[index] = target;
    }

    public StackProducer getKey() {
        return this.key;
    }

    public Target[] getTargets() {
        return this.targets;
    }

    public Target getDefaultTarget() {
        return this.defaultTarget;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public int getPadding() {
        return this.padding;
    }

    @Override
    public boolean constrainsStack() {
        if (this.defaultTarget.isBackwardBranchTarget()) {
            return true;
        }
        for (int i = 0; i != this.targets.length; ++i) {
            if (!this.targets[i].isBackwardBranchTarget()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visit(OperandVisitor visitor) {
        this.key = visitor.doOperand(this, this.key);
    }
}

