/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.beans;

import com.ochafik.util.string.StringUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeansUtils {
    public static final void markTransientProperty(String name, Class<?> classe) throws IntrospectionException {
        BeanInfo info = Introspector.getBeanInfo(classe);
        PropertyDescriptor[] propertyDescriptors = info.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            PropertyDescriptor pd = propertyDescriptors[i];
            if (!pd.getName().equals(name)) continue;
            pd.setValue("transient", Boolean.TRUE);
        }
    }

    public static void addPropertyChangeListener(Object bean, final String propertyName, final PropertyChangeListener listener) {
        if (bean == null) {
            throw new NullPointerException("Null bean !");
        }
        try {
            bean.getClass().getMethod("addPropertyChangeListener", String.class, PropertyChangeListener.class).invoke(bean, propertyName, listener);
        }
        catch (Exception ex) {
            try {
                bean.getClass().getMethod("addPropertyChangeListener", PropertyChangeListener.class).invoke(bean, new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        if (propertyName.equals(evt.getPropertyName())) {
                            listener.propertyChange(evt);
                        }
                    }
                });
            }
            catch (Exception ex2) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static void removePropertyChangeListener(Object bean, String propertyName, PropertyChangeListener listener) {
        if (bean == null) {
            throw new NullPointerException("Null bean !");
        }
        try {
            bean.getClass().getMethod("removePropertyChangeListener", PropertyChangeListener.class).invoke(bean, listener);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Object get(Object bean, String propertyName) {
        return BeansUtils.get(bean, propertyName, Object.class);
    }

    public static <T> T get(Object bean, String propertyName, Class<T> propertyClass) {
        if (bean == null) {
            throw new NullPointerException("Null bean !");
        }
        try {
            Method m;
            String cap = StringUtils.capitalize(propertyName);
            if (propertyClass == Boolean.class) {
                try {
                    m = bean.getClass().getMethod("is" + cap, new Class[0]);
                }
                catch (NoSuchMethodException ex) {
                    m = bean.getClass().getMethod("get" + cap, new Class[0]);
                }
            } else {
                m = bean.getClass().getMethod("get" + cap, new Class[0]);
            }
            return propertyClass.cast(m.invoke(bean, new Object[0]));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> void set(Object bean, String propertyName, Class<T> propertyClass, T value) {
        if (bean == null) {
            throw new NullPointerException("Null bean !");
        }
        try {
            bean.getClass().getMethod("set" + StringUtils.capitalize(propertyName), propertyClass).invoke(bean, value);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

