/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.io;

import com.ochafik.io.IOUtils;
import com.ochafik.util.string.RegexUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadText {
    private static final Pattern charsetPattern = Pattern.compile(";\\s*charset\\s*=\\s*([\\w-_]+)", 34);
    static Pattern[] embeddedCharsetPatterns = new Pattern[]{Pattern.compile("CONTENT\\s*=\\s*\"text/\\w+;\\s*charset\\s*=\\s*([^\";\\s]+)\\s*\"", 34), Pattern.compile("<?\\s*xml\\s+[^>]*encoding\\s*=\\s*\"([^\"]+)\"", 34)};

    public static final String readText(Reader in) throws IOException {
        int len;
        char[] ch = new char[1024];
        StringBuffer b = new StringBuffer();
        while ((len = in.read(ch)) > 0) {
            b.append(ch, 0, len);
        }
        return b.toString();
    }

    public static final String readText(File f) {
        if (f == null) {
            return null;
        }
        try {
            String l;
            BufferedReader in = new BufferedReader(new FileReader(f));
            StringBuffer buff = new StringBuffer((int)f.length());
            boolean first = true;
            while ((l = in.readLine()) != null) {
                if (first) {
                    first = false;
                } else {
                    buff.append('\n');
                }
                buff.append(l);
            }
            return buff.toString();
        }
        catch (Exception except) {
            except.printStackTrace();
            return null;
        }
    }

    public static final void writeProperties(Properties properties, File file) throws IOException {
        File parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        properties.store(out, file.getName());
        ((OutputStream)out).close();
    }

    public static final Properties readProperties(File file, boolean failIfNotExists) throws IOException {
        Properties properties = new Properties();
        if (!file.exists()) {
            if (failIfNotExists) {
                return null;
            }
        } else {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            properties.load(in);
            ((InputStream)in).close();
        }
        return properties;
    }

    public static final String readText(URL u) throws IOException {
        if (u == null) {
            return null;
        }
        String encoding = null;
        URLConnection con = u.openConnection();
        if (con instanceof HttpURLConnection) {
            String contentType = con.getContentType();
            encoding = RegexUtils.findFirst(contentType, charsetPattern, 1);
        }
        InputStream in = con.getInputStream();
        String text = ReadText.readText(in, encoding);
        in.close();
        return text;
    }

    private static String readText(InputStream in, String encoding) throws IOException {
        String l;
        if (in == null) {
            return null;
        }
        if (encoding == null) {
            Pattern charsetPat;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            IOUtils.readWrite(in, bout);
            byte[] bytes = bout.toByteArray();
            String ascii = new String(bytes, "ascii");
            Pattern[] arr$ = embeddedCharsetPatterns;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (encoding = RegexUtils.findFirst(ascii, charsetPat = arr$[i$], 1)) == null; ++i$) {
            }
            if (encoding != null) {
                try {
                    return new String(bytes, encoding);
                }
                catch (UnsupportedEncodingException ex) {
                    ex.printStackTrace();
                }
            }
            return new String(bytes);
        }
        BufferedReader rin = new BufferedReader(encoding == null ? new InputStreamReader(in) : new InputStreamReader(in, encoding));
        StringBuffer buff = new StringBuffer();
        boolean first = true;
        while ((l = rin.readLine()) != null) {
            if (first) {
                first = false;
            } else {
                buff.append('\n');
            }
            buff.append(l);
        }
        return buff.toString();
    }

    public static final String readText(InputStream in) throws IOException {
        return ReadText.readText(in, null);
    }

    public static final List<String> readLines(String s) throws IOException {
        return ReadText.readLines(new FileReader(s));
    }

    public static final List<String> readLines(URL u) throws IOException {
        InputStream in = u.openStream();
        List<String> r = ReadText.readLines(in);
        in.close();
        return r;
    }

    public static final List<String> readLines(InputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        List<String> r = ReadText.readLines(new InputStreamReader(in));
        in.close();
        return r;
    }

    public static final List<String> readLines(Reader r) throws IOException {
        String l;
        ArrayList<String> v = new ArrayList<String>();
        BufferedReader in = new BufferedReader(r);
        while ((l = in.readLine()) != null) {
            v.add(l);
        }
        return v;
    }

    public static final String[] readLinesArray(String s) throws IOException {
        List<String> v = ReadText.readLines(s);
        String[] ret = new String[v.size()];
        int i = 0;
        for (String line : v) {
            ret[i++] = line;
        }
        return ret;
    }
}

