/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.reflect;

import com.ochafik.util.string.RegexUtils;
import com.ochafik.util.string.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GettersAndSettersHelper {
    public final Map<String, GetterAndSetterInfo> gettersAndSetters = new HashMap<String, GetterAndSetterInfo>();
    static Pattern getterSetterPattern = Pattern.compile("(is|get|set)([A-Z]\\w+)");
    final FieldGetter fieldGetter;

    public GettersAndSettersHelper(Class<?> type, FieldGetter fieldGetter) {
        this.fieldGetter = fieldGetter;
        for (Method method : type.getMethods()) {
            GetterAndSetterInfo getterAndSetter;
            boolean isGetter;
            String name;
            String[] match;
            int nParams = method.getParameterTypes().length;
            if (nParams > 1 || (match = RegexUtils.match(name = method.getName(), getterSetterPattern)) == null) continue;
            Class<?> returnType = method.getReturnType();
            String fieldName = StringUtils.uncapitalize(match[2]);
            boolean bl = isGetter = !match[1].equals("set");
            if (isGetter) {
                if (nParams != 0) continue;
                getterAndSetter = this.getOrCreatePair(fieldName);
                if (getterAndSetter.getter != null) {
                    if (getterAndSetter.getter.getReturnType().isAssignableFrom(returnType)) {
                        getterAndSetter.getter = method;
                    }
                } else {
                    getterAndSetter.getter = method;
                }
                if (getterAndSetter.isConsistent()) continue;
                getterAndSetter.setter = null;
                continue;
            }
            if (nParams != 1) continue;
            getterAndSetter = this.getOrCreatePair(fieldName);
            if (getterAndSetter.setter != null) continue;
            getterAndSetter.setter = method;
            if (getterAndSetter.isConsistent()) continue;
            getterAndSetter.setter = null;
        }
    }

    public Set<String> getFieldNames() {
        return this.gettersAndSetters.keySet();
    }

    public Method getGetter(String fieldName) {
        GetterAndSetterInfo pair = this.gettersAndSetters.get(fieldName);
        return pair == null ? null : pair.getter;
    }

    public Method getSetter(String fieldName) {
        GetterAndSetterInfo pair = this.gettersAndSetters.get(fieldName);
        return pair == null ? null : pair.setter;
    }

    public Type getFieldType(String fieldName) {
        GetterAndSetterInfo pair = this.gettersAndSetters.get(fieldName);
        if (pair == null) {
            return null;
        }
        if (pair.getter != null) {
            return pair.getter.getGenericReturnType();
        }
        if (pair.setter != null) {
            return pair.setter.getGenericParameterTypes()[0];
        }
        return null;
    }

    public void assertConsistentPair(GetterAndSetterInfo p) {
        if (p.getter != null && p.setter != null) {
            Class<?> getType = p.getter.getReturnType();
            Class<?> setType = p.setter.getParameterTypes()[0];
            assert (setType.isAssignableFrom(getType));
        }
    }

    protected GetterAndSetterInfo getOrCreatePair(String fieldName) {
        GetterAndSetterInfo getterAndSetter = this.gettersAndSetters.get(fieldName);
        if (getterAndSetter == null) {
            getterAndSetter = new GetterAndSetterInfo();
            this.gettersAndSetters.put(fieldName, getterAndSetter);
        }
        return getterAndSetter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface FieldGetter {
        public Field getField(Class<?> var1, String var2) throws SecurityException, NoSuchFieldException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetterAndSetterInfo {
        public Method getter;
        public Method setter;
        public String fieldName;
        public Class<?> elementType;

        public boolean isFull() {
            return this.getter != null && this.setter != null;
        }

        public GetterAndSetterInfo(String fieldName, Class<?> elementType, Method getter, Method setter, Field field) {
            this.elementType = elementType;
            this.fieldName = fieldName;
            this.getter = getter;
            this.setter = setter;
        }

        public GetterAndSetterInfo() {
        }

        public boolean isConsistent() {
            if (this.getter == null || this.setter == null) {
                return true;
            }
            Class<?>[] pts = this.setter.getParameterTypes();
            if (pts.length != 1) {
                return false;
            }
            Class<?> pt = pts[0];
            return pt.isAssignableFrom(this.getter.getReturnType());
        }
    }
}

