/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.util.listenable;

import com.ochafik.util.listenable.AdaptedCollection;
import com.ochafik.util.listenable.Adapter;
import com.ochafik.util.listenable.DefaultListenableCollection;
import com.ochafik.util.listenable.DefaultListenableSet;
import com.ochafik.util.listenable.ListenableCollection;
import com.ochafik.util.listenable.ListenableCollections;
import com.ochafik.util.listenable.ListenableMap;
import com.ochafik.util.listenable.ListenableSet;
import com.ochafik.util.listenable.ListenableSupport;
import com.ochafik.util.listenable.UnmodifiableEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultListenableMap<K, V>
implements ListenableMap<K, V> {
    Map<K, V> map;
    DefaultListenableSet<K> keySet;
    DefaultListenableSet<Map.Entry<K, V>> entrySet;
    ListenableSupport<V> valuesSupport;
    ListenableCollection<V> values;
    protected Adapter<Map.Entry<K, V>, K> entryToKeyAdapter = new Adapter<Map.Entry<K, V>, K>(){

        @Override
        public K adapt(Map.Entry<K, V> value) {
            return value.getKey();
        }
    };
    protected Adapter<Map.Entry<K, V>, V> entryToValueAdapter = new Adapter<Map.Entry<K, V>, V>(){

        @Override
        public V adapt(Map.Entry<K, V> value) {
            return value.getValue();
        }
    };

    public DefaultListenableMap(Map<K, V> map) {
        this.map = map;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public void clear() {
        ArrayList<Map.Entry<K, V>> copy = new ArrayList<Map.Entry<K, V>>(this.map.entrySet());
        this.map.clear();
        this.propagateRemoved(copy);
    }

    @Override
    public boolean equals(Object obj) {
        return this.map.equals(obj);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public V put(K key, V value) {
        V v = this.map.put(key, value);
        if (v != null) {
            this.propagateUpdated(key, v, value);
        } else {
            this.propagateAdded(key, value);
        }
        return v;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> e : t.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        V v = this.map.remove(key);
        if (v != null) {
            this.propagateRemoved(Collections.singletonMap(key, v).entrySet());
        }
        return v;
    }

    void propagateAdded(K key, V value) {
        if (this.keySet != null) {
            this.keySet.collectionSupport.fireAdded(this.keySet, Collections.singleton(key));
        }
        if (this.entrySet != null) {
            this.entrySet.collectionSupport.fireAdded(this.entrySet, Collections.singleton(new UnmodifiableEntry<K, V>(key, value)));
        }
        if (this.values != null) {
            this.valuesSupport.fireAdded(this.values, Collections.singleton(value));
        }
    }

    void propagateRemoved(Collection<Map.Entry<K, V>> entries) {
        if (this.keySet != null) {
            this.keySet.collectionSupport.fireRemoved(this.keySet, new AdaptedCollection<Map.Entry<K, V>, K>(entries, this.entryToKeyAdapter));
        }
        if (this.entrySet != null) {
            this.entrySet.collectionSupport.fireRemoved(this.entrySet, entries);
        }
        if (this.values != null) {
            this.valuesSupport.fireRemoved(this.values, new AdaptedCollection<Map.Entry<K, V>, V>(entries, this.entryToValueAdapter));
        }
    }

    void propagateUpdated(K key, V oldValue, V newValue) {
        boolean different;
        if (this.keySet != null) {
            this.keySet.collectionSupport.fireUpdated(this.keySet, Collections.singleton(key));
        }
        boolean bl = different = !oldValue.equals(newValue);
        if (this.entrySet != null) {
            Set<UnmodifiableEntry<K, V>> newEntries = Collections.singleton(new UnmodifiableEntry<K, V>(key, newValue));
            if (different) {
                Set<UnmodifiableEntry<K, V>> oldEntries = Collections.singleton(new UnmodifiableEntry<K, V>(key, oldValue));
                this.entrySet.collectionSupport.fireRemoved(this.entrySet, oldEntries);
                this.entrySet.collectionSupport.fireAdded(this.entrySet, newEntries);
            } else {
                this.entrySet.collectionSupport.fireUpdated(this.entrySet, newEntries);
            }
        }
        if (this.values != null) {
            if (different) {
                this.valuesSupport.fireRemoved(this.values, Collections.singleton(oldValue));
                this.valuesSupport.fireAdded(this.values, Collections.singleton(newValue));
            } else {
                this.valuesSupport.fireUpdated(this.values, Collections.singleton(newValue));
            }
        }
    }

    @Override
    public ListenableSet<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new DefaultListenableSet<K>(this.map.keySet()){

                @Override
                public boolean remove(Object o) {
                    Object value = DefaultListenableMap.this.map.remove(o);
                    if (value != null) {
                        DefaultListenableMap.this.propagateRemoved(Collections.singletonMap(o, value).entrySet());
                        return true;
                    }
                    return false;
                }

                @Override
                public void clear() {
                    DefaultListenableMap.this.clear();
                }

                @Override
                public boolean removeAll(Collection<?> c) {
                    if (!this.collectionSupport.hasListeners()) {
                        return this.collection.removeAll(c);
                    }
                    boolean changed = false;
                    for (Object o : c) {
                        changed = this.remove(o) || changed;
                    }
                    return changed;
                }

                @Override
                public boolean add(K o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean addAll(Collection<? extends K> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean retainAll(Collection<?> c) {
                    if (!this.collectionSupport.hasListeners()) {
                        return this.collection.retainAll(c);
                    }
                    ArrayList removedElements = new ArrayList(c.size());
                    Iterator it = DefaultListenableMap.this.map.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry e = it.next();
                        if (c.contains(e.getKey())) continue;
                        it.remove();
                        removedElements.add(e);
                    }
                    DefaultListenableMap.this.propagateRemoved(removedElements);
                    return !removedElements.isEmpty();
                }

                @Override
                public Iterator<K> iterator() {
                    return new DefaultListenableCollection.ListenableIterator((DefaultListenableCollection)this, this.collection.iterator()){

                        @Override
                        public void remove() {
                            Object assoc = DefaultListenableMap.this.get(this.lastValue);
                            this.iterator.remove();
                            DefaultListenableMap.this.propagateRemoved(Collections.singletonMap(this.lastValue, assoc).entrySet());
                        }
                    };
                }
            };
        }
        return this.keySet;
    }

    @Override
    public ListenableSet<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new DefaultListenableSet<Map.Entry<K, V>>(this.map.entrySet()){

                @Override
                public boolean remove(Object o) {
                    Map.Entry entry = (Map.Entry)o;
                    Object value = DefaultListenableMap.this.map.remove(entry.getKey());
                    if (value != null) {
                        DefaultListenableMap.this.propagateRemoved(Collections.singleton(entry));
                        return true;
                    }
                    return false;
                }

                @Override
                public void clear() {
                    DefaultListenableMap.this.clear();
                }

                @Override
                public boolean removeAll(Collection<?> c) {
                    if (!this.collectionSupport.hasListeners()) {
                        return this.collection.removeAll(c);
                    }
                    boolean changed = false;
                    for (Object o : c) {
                        changed = this.remove(o) || changed;
                    }
                    return changed;
                }

                @Override
                public boolean add(Map.Entry<K, V> o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean retainAll(Collection<?> c) {
                    if (!this.collectionSupport.hasListeners()) {
                        return this.collection.retainAll(c);
                    }
                    ArrayList removedElements = new ArrayList(c.size());
                    Iterator it = DefaultListenableMap.this.map.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry e = it.next();
                        if (c.contains(e)) continue;
                        it.remove();
                        removedElements.add(e);
                    }
                    DefaultListenableMap.this.propagateRemoved(removedElements);
                    return !removedElements.isEmpty();
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new DefaultListenableCollection.ListenableIterator((DefaultListenableCollection)this, this.collection.iterator()){

                        @Override
                        public void remove() {
                            this.iterator.remove();
                            DefaultListenableMap.this.propagateRemoved(Collections.singleton(this.lastValue));
                        }
                    };
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public ListenableCollection<V> values() {
        if (this.values == null) {
            this.valuesSupport = new ListenableSupport();
            this.values = ListenableCollections.unmodifiableCollection(new DefaultListenableCollection<V>(this.map.values(), this.valuesSupport));
        }
        return this.values;
    }
}

