/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.util.listenable;

import com.ochafik.lang.Threads;
import com.ochafik.util.listenable.AdaptedCollection;
import com.ochafik.util.listenable.Adapter;
import com.ochafik.util.listenable.CollectionEvent;
import com.ochafik.util.listenable.CollectionListener;
import com.ochafik.util.listenable.DefaultListenableCollection;
import com.ochafik.util.listenable.DefaultListenableList;
import com.ochafik.util.listenable.DefaultListenableMap;
import com.ochafik.util.listenable.DefaultListenableSet;
import com.ochafik.util.listenable.DefaultListenableSortedSet;
import com.ochafik.util.listenable.Filter;
import com.ochafik.util.listenable.ListenableCollection;
import com.ochafik.util.listenable.ListenableList;
import com.ochafik.util.listenable.ListenableMap;
import com.ochafik.util.listenable.ListenableSet;
import com.ochafik.util.listenable.Pair;
import com.ochafik.util.listenable.SynchronizedListenableCollection;
import com.ochafik.util.listenable.SynchronizedListenableList;
import com.ochafik.util.listenable.SynchronizedListenableMap;
import com.ochafik.util.listenable.SynchronizedListenableSet;
import com.ochafik.util.listenable.UnmodifiableListenableCollection;
import com.ochafik.util.listenable.UnmodifiableListenableList;
import com.ochafik.util.listenable.UnmodifiableListenableMap;
import com.ochafik.util.listenable.UnmodifiableListenableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenableCollections {
    public static <T> ListenableList<T> asList(ListenableCollection<T> source) {
        if (source instanceof ListenableList) {
            return (ListenableList)source;
        }
        DefaultListenableList<T> out = new DefaultListenableList<T>(new ArrayList<T>(source));
        ListenableCollections.bind(source, out);
        return out;
    }

    public static <T> void bind(final ListenableCollection<T> a, final ListenableCollection<T> b) {
        CollectionListener listener = new CollectionListener<T>(){
            boolean currentlyPropagating = false;

            void add(T t, ListenableCollection<T> source, ListenableCollection<T> recipient) {
                if (recipient instanceof List && source instanceof SortedSet) {
                    ListenableList recipientList = (ListenableList)recipient;
                    Comparator comparator = ((SortedSet)((Object)source)).comparator();
                    int i = comparator != null ? Collections.binarySearch(recipientList, t, comparator) : Collections.binarySearch(recipientList, t);
                    if (i >= 0) {
                        recipientList.set(i, t);
                    } else {
                        recipientList.add(-i - 1, t);
                    }
                } else {
                    recipient.add(t);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void collectionChanged(CollectionEvent<T> e) {
                if (this.currentlyPropagating) {
                    return;
                }
                try {
                    this.currentlyPropagating = true;
                    Object source = e.getSource();
                    ListenableCollection recipient = source == a ? b : a;
                    for (Object t : e.getElements()) {
                        switch (e.getType()) {
                            case ADDED: {
                                this.add(t, (ListenableCollection)source, recipient);
                                break;
                            }
                            case REMOVED: {
                                recipient.remove(t);
                                break;
                            }
                            case UPDATED: {
                                if (recipient instanceof List) {
                                    List recipientList = (List)((Object)recipient);
                                    int i = recipientList.indexOf(t);
                                    recipientList.set(i, t);
                                    break;
                                }
                                if (recipient instanceof Set) {
                                    this.add(t, (ListenableCollection)source, recipient);
                                    break;
                                }
                                recipient.remove(t);
                                this.add(t, (ListenableCollection)source, recipient);
                            }
                        }
                    }
                    Object var9_8 = null;
                    this.currentlyPropagating = false;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    this.currentlyPropagating = false;
                    throw throwable;
                }
            }
        };
        a.addCollectionListener(listener);
        b.addCollectionListener(listener);
    }

    public static final <T> ListenableSet<T> unmodifiableSet(ListenableSet<T> set) {
        return new UnmodifiableListenableSet<T>(set);
    }

    public static final <T> ListenableCollection<T> unmodifiableCollection(ListenableCollection<T> col) {
        return new UnmodifiableListenableCollection<T>(col);
    }

    public static final <T> ListenableList<T> unmodifiableList(ListenableList<T> col) {
        return new UnmodifiableListenableList<T>(col);
    }

    public static final <K, V> ListenableMap<K, V> unmodifiableMap(ListenableMap<K, V> map) {
        return new UnmodifiableListenableMap<K, V>(map);
    }

    public static final <T> ListenableSet<T> synchronizedSet(ListenableSet<T> set) {
        return new SynchronizedListenableSet<T>(set);
    }

    public static final <T> ListenableCollection<T> synchronizedCollection(ListenableCollection<T> col) {
        return new SynchronizedListenableCollection<T>(col);
    }

    public static final <T> ListenableList<T> synchronizedList(ListenableList<T> col) {
        return new SynchronizedListenableList<T>(col);
    }

    public static final <K, V> ListenableMap<K, V> synchronizedMap(ListenableMap<K, V> map) {
        return new SynchronizedListenableMap<K, V>(map);
    }

    public static final <T> ListenableCollection<T> listenableCollection(Collection<T> collectionToWrap) {
        if (collectionToWrap instanceof ListenableCollection) {
            return (ListenableCollection)collectionToWrap;
        }
        if (collectionToWrap instanceof Set) {
            return ListenableCollections.listenableSet((Set)collectionToWrap);
        }
        if (collectionToWrap instanceof List) {
            return ListenableCollections.listenableList((List)collectionToWrap);
        }
        return new DefaultListenableCollection<T>(collectionToWrap);
    }

    public static final <T> ListenableList<T> listenableList(List<T> listToWrap) {
        if (listToWrap instanceof ListenableList) {
            return (ListenableList)listToWrap;
        }
        if (listToWrap instanceof RandomAccess) {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class RandomAccessListenableList
            extends DefaultListenableList<T>
            implements RandomAccess {
                public RandomAccessListenableList(List<T> l) {
                    super(l);
                }
            }
            return new RandomAccessListenableList(listToWrap);
        }
        return new DefaultListenableList<T>(listToWrap);
    }

    public static final <T> ListenableSet<T> listenableSet(Set<T> setToWrap) {
        if (setToWrap instanceof ListenableSet) {
            return (ListenableSet)setToWrap;
        }
        if (setToWrap instanceof SortedSet) {
            return new DefaultListenableSortedSet((SortedSet)setToWrap);
        }
        return new DefaultListenableSet<T>(setToWrap);
    }

    public static final <K, V> ListenableMap<K, V> listenableMap(Map<K, V> x) {
        return new DefaultListenableMap<K, V>(x);
    }

    public static <U, V> Collection<V> adapt(Collection<U> col, Adapter<U, V> adapter) {
        return new AdaptedCollection<U, V>(col, adapter);
    }

    public static <U, V> MapResult<U, V> map(Collection<U> input, final Adapter<U, V> mapper, int threadsCount) {
        if (threadsCount < 0) {
            threadsCount = -threadsCount * Runtime.getRuntime().availableProcessors();
        }
        final Iterator<U> it = input.iterator();
        final ListenableList out = ListenableCollections.synchronizedList(ListenableCollections.listenableList(new ArrayList(input.size())));
        final ListenableList errorsOut = ListenableCollections.synchronizedList(ListenableCollections.listenableList(new ArrayList()));
        Threads threadsJoint = new Threads();
        Runnable worker = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (!Thread.interrupted()) {
                    ListenableList listenableList;
                    Object value;
                    Iterator iterator = it;
                    synchronized (iterator) {
                        if (!it.hasNext()) {
                            break;
                        }
                        value = it.next();
                    }
                    try {
                        Object mappedValue = mapper.adapt(value);
                        listenableList = out;
                        synchronized (listenableList) {
                            out.add(mappedValue);
                        }
                    }
                    catch (Throwable th) {
                        listenableList = errorsOut;
                        synchronized (listenableList) {
                            errorsOut.add(new Pair(value, th));
                        }
                    }
                }
            }
        };
        if (threadsCount == 0) {
            worker.run();
        } else {
            int iWorker = threadsCount;
            while (iWorker-- != 0) {
                threadsJoint.add(worker);
            }
            threadsJoint.start();
        }
        return new MapResult(threadsJoint, out, errorsOut);
    }

    public <T> int removeIf(Collection<T> collection, Filter<T> filter) {
        int removed = 0;
        Iterator<T> it = collection.iterator();
        while (it.hasNext()) {
            if (!filter.accept(it.next())) continue;
            it.remove();
            ++removed;
        }
        return removed;
    }

    public <T> int retainIf(Collection<T> collection, Filter<T> filter) {
        int removed = 0;
        Iterator<T> it = collection.iterator();
        while (it.hasNext()) {
            if (filter.accept(it.next())) continue;
            it.remove();
            ++removed;
        }
        return removed;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MapResult<U, V> {
        private final ListenableList<V> values;
        private final Threads threads;
        private final ListenableList<Pair<U, Throwable>> errors;

        public MapResult(Threads threads, ListenableList<V> out, ListenableList<Pair<U, Throwable>> errorsOut) {
            this.values = ListenableCollections.unmodifiableList(out);
            this.threads = threads;
            this.errors = ListenableCollections.unmodifiableList(errorsOut);
        }

        public ListenableList<V> getValues() {
            return this.values;
        }

        public Threads getThreads() {
            return this.threads;
        }

        public ListenableList<Pair<U, Throwable>> getErrors() {
            return this.errors;
        }
    }
}

