/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.Field;
import com.sun.squawk.Klass;
import com.sun.squawk.Method;
import com.sun.squawk.Suite;
import com.sun.squawk.VM;
import com.sun.squawk.translator.ir.InstructionEmitter;
import com.sun.squawk.vm.FieldOffsets;
import com.sun.squawk.vm.Mnemonics;
import com.sun.squawk.vm.OPC;
import java.io.CharArrayWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public final class CHeaderFileCreator {
    private final Properties map;

    public static boolean update(Suite bootstrapSuite, File file, Properties properties) throws IOException {
        CHeaderFileCreator creator = new CHeaderFileCreator(properties);
        CharArrayWriter caw = new CharArrayWriter(file.exists() ? (int)file.length() : 0);
        PrintWriter out = new PrintWriter(caw);
        creator.writeHeader(bootstrapSuite, out);
        char[] content = caw.toCharArray();
        char[] oldContent = null;
        if (file.exists()) {
            int count;
            FileReader fr = new FileReader(file);
            int length = (int)file.length();
            oldContent = new char[length];
            for (int n = 0; n < length; n += count) {
                count = fr.read(oldContent, n, length - n);
                if (count >= 0) continue;
                throw new EOFException();
            }
            fr.close();
        }
        if (!Arrays.equals(content, oldContent)) {
            file.delete();
            file.getParentFile().mkdirs();
            FileWriter fw = new FileWriter(file);
            fw.write(content);
            fw.close();
            file.setReadOnly();
            return true;
        }
        return false;
    }

    private CHeaderFileCreator(Properties properties) {
        this.map = properties;
    }

    private Klass lookupClass(Suite suite, String name, String fieldSpec) {
        Klass klass = suite.lookup(name);
        if (klass == null) {
            throw new RuntimeException("Can't find the class '" + name + "' specified in '" + fieldSpec + "'");
        }
        return klass;
    }

    private void verifyFieldOffsets() {
        Suite suite = VM.getCurrentIsolate().getBootstrapSuite();
        Klass k = suite.lookup("com.sun.squawk.vm.FieldOffsets");
        int count = k.getFieldCount(true);
        for (int i = 0; i != count; ++i) {
            boolean found;
            Field field = k.getField(i, true);
            if (field.isPrivate()) continue;
            String name = field.getName();
            long constantValue = field.getPrimitiveConstantValue();
            int offset = FieldOffsets.decodeOffset((long)constantValue);
            int typeID = FieldOffsets.decodeSystemID((long)constantValue);
            int indexOf$ = name.indexOf(36);
            if (indexOf$ == -1) {
                throw new RuntimeException("Constant defined in com.sun.squawk.vm.FieldOffsets does not include '$': " + name);
            }
            String className = name.substring(0, indexOf$).replace('_', '.');
            String fieldName = name.substring(indexOf$ + 1);
            Klass klass = this.lookupClass(suite, className, field.toString());
            boolean bl = found = this.verifyFieldOffset(field.toString(), offset, typeID, fieldName, klass, false) || this.verifyFieldOffset(field.toString(), offset, typeID, fieldName, klass, true);
            if (found) continue;
            throw new RuntimeException("Missing definition of '" + className + "." + fieldName + "'");
        }
    }

    private boolean verifyFieldOffset(String fieldSpec, int fieldOffset, int fieldTypeID, String fieldName, Klass klass, boolean isStatic) {
        int fieldCount = klass.getFieldCount(isStatic);
        boolean found = false;
        for (int j = 0; j != fieldCount; ++j) {
            Field squawkField = klass.getField(j, isStatic);
            if (!squawkField.getName().equals(fieldName)) continue;
            int offset = squawkField.getOffset();
            Klass type = squawkField.getType();
            int systemID = type.getSystemID();
            switch (systemID) {
                default: {
                    systemID = 1;
                    break;
                }
                case 6: {
                    systemID = 7;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 14: 
            }
            if (offset != fieldOffset) {
                throw new RuntimeException("The value of '" + fieldSpec + "' should be " + offset + " not " + fieldOffset);
            }
            if (fieldTypeID != systemID) {
                throw new RuntimeException("The CID of '" + fieldSpec + "' should be " + fieldTypeID + " not " + systemID);
            }
            found = true;
            break;
        }
        return found;
    }

    private void verifyMethodOffsets() {
        boolean errors = false;
        Suite suite = VM.getCurrentIsolate().getBootstrapSuite();
        Klass MethodOffsetsKlass = suite.lookup("com.sun.squawk.vm.MethodOffsets");
        int count = MethodOffsetsKlass.getFieldCount(true);
        for (int i = 0; i != count; ++i) {
            Klass[] parameters;
            String methodName;
            int indexOf$;
            boolean isStatic;
            Field field = MethodOffsetsKlass.getField(i, true);
            String name = field.getName();
            int value = (int)field.getPrimitiveConstantValue();
            boolean bl = isStatic = !name.startsWith("virtual$");
            if (!isStatic) {
                name = name.substring("virtual$".length());
            }
            if ((indexOf$ = name.indexOf(36)) == -1) {
                System.err.println("Constant defined in com.sun.squawk.vm.MethodOffsets does not include '$': " + name);
                errors = true;
                continue;
            }
            String className = name.substring(0, indexOf$).replace('_', '.');
            String nameAndParameters = name.substring(indexOf$ + 1);
            if ((indexOf$ = nameAndParameters.indexOf(36)) != -1) {
                methodName = nameAndParameters.substring(0, indexOf$);
                StringTokenizer st = new StringTokenizer(nameAndParameters.substring(indexOf$ + 1), "$");
                parameters = new Klass[st.countTokens()];
                for (int j = 0; j != parameters.length; ++j) {
                    String typeName = st.nextToken().replace('_', '.');
                    parameters[j] = this.lookupClass(suite, typeName, field.toString());
                }
            } else {
                methodName = nameAndParameters;
                parameters = null;
            }
            Klass klass = this.lookupClass(suite, className, field.toString());
            int methodCount = klass.getMethodCount(isStatic);
            boolean found = false;
            block2: for (int j = 0; j != methodCount; ++j) {
                int offset;
                Method squawkMethod = klass.getMethod(j, isStatic);
                if (!squawkMethod.getName().equals(methodName)) continue;
                if (parameters != null) {
                    Klass[] types = squawkMethod.getParameterTypes();
                    if (types.length != parameters.length) continue;
                    for (int k = 0; k != types.length; ++k) {
                        if (types[k] != parameters[k]) continue block2;
                    }
                }
                if ((offset = squawkMethod.getOffset()) != value) {
                    System.err.println("The value of '" + field + "' should be " + offset + " not " + value);
                    errors = true;
                }
                found = true;
                break;
            }
            if (found) continue;
            System.err.println("Missing definition of '" + className + "." + nameAndParameters + "'");
            errors = true;
        }
        if (errors) {
            System.exit(-1);
        }
    }

    private void outputGlobalNames(PrintWriter out, Hashtable<String, Integer> globals, String functionName) {
        out.println("const char* " + functionName + "(int index) {");
        out.println("    switch(index) {");
        for (Map.Entry<String, Integer> entry : globals.entrySet()) {
            String name = entry.getKey();
            int offset = entry.getValue();
            name = name.replace('.', '_');
            out.println("        case " + offset + ": return \"" + name + "\";");
        }
        out.println("        default: return \"" + functionName + ": unknown global index\";");
        out.println("    }");
        out.println("}");
    }

    private void writeHeader(Suite suite, PrintWriter out) throws IOException {
        String name;
        out.println("/*");
        out.println(" * Copyright 2004-2008 Sun Microsystems, Inc. All Rights Reserved.");
        out.println(" * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER");
        out.println(" * ");
        out.println(" * This code is free software; you can redistribute it and/or modify");
        out.println(" * it under the terms of the GNU General Public License version 2");
        out.println(" * only, as published by the Free Software Foundation.");
        out.println(" * ");
        out.println(" * This code is distributed in the hope that it will be useful, but");
        out.println(" * WITHOUT ANY WARRANTY; without even the implied warranty of");
        out.println(" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU");
        out.println(" * General Public License version 2 for more details (a copy is");
        out.println(" * included in the LICENSE file that accompanied this code).");
        out.println(" * ");
        out.println(" * You should have received a copy of the GNU General Public License");
        out.println(" * version 2 along with this work; if not, write to the Free Software");
        out.println(" * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA");
        out.println(" * 02110-1301 USA");
        out.println(" * ");
        out.println(" * Please contact Sun Microsystems, Inc., 16 Network Circle, Menlo");
        out.println(" * Park, CA 94025 or visit www.sun.com if you need additional");
        out.println(" * information or have any questions.");
        out.println("*/");
        int classCount = suite.getClassCount();
        for (int cid = 0; cid != classCount; ++cid) {
            String wholeName;
            Field field;
            int fid;
            Klass klass = suite.getKlass(cid);
            if (klass == null || klass.isArray() || klass.getInternalName().charAt(0) == '-' || klass.isSynthetic()) continue;
            out.println("#define " + CHeaderFileCreator.fix(klass.getName()) + " " + cid);
            int fieldCount = klass.getFieldCount(false);
            for (fid = 0; fid != fieldCount; ++fid) {
                field = klass.getField(fid, false);
                wholeName = CHeaderFileCreator.fix(klass.getName() + '_' + field.getName());
                out.print("#define " + wholeName + "(oop) ");
                switch (field.getType().getSystemID()) {
                    case 6: 
                    case 7: {
                        out.print("getByte");
                        break;
                    }
                    case 8: {
                        out.print("getUShort");
                        break;
                    }
                    case 9: {
                        out.print("getShort");
                        break;
                    }
                    case 10: 
                    case 13: {
                        out.print("getInt");
                        break;
                    }
                    case 11: 
                    case 14: {
                        out.print("getLongAtWord");
                        break;
                    }
                    case 36: 
                    case 38: {
                        out.print("getUWord");
                        break;
                    }
                    default: {
                        out.print("getObject");
                    }
                }
                out.println("((oop), " + field.getOffset() + ")");
            }
            for (fid = 0; fid != fieldCount; ++fid) {
                field = klass.getField(fid, false);
                wholeName = CHeaderFileCreator.fix(klass.getName() + '_' + field.getName());
                out.print("#define set_" + wholeName + "(oop, value) ");
                switch (field.getType().getSystemID()) {
                    case 6: 
                    case 7: {
                        out.print("setByte");
                        break;
                    }
                    case 8: 
                    case 9: {
                        out.print("setShort");
                        break;
                    }
                    case 10: 
                    case 13: {
                        out.print("setInt");
                        break;
                    }
                    case 11: 
                    case 14: {
                        out.print("setLongAtWord");
                        break;
                    }
                    case 36: 
                    case 38: {
                        out.print("setUWord");
                        break;
                    }
                    default: {
                        out.print("setObject");
                    }
                }
                out.println("((oop), " + field.getOffset() + ", value)");
            }
            fieldCount = klass.getFieldCount(true);
            block33: for (fid = 0; fid != fieldCount; ++fid) {
                String value;
                field = klass.getField(fid, true);
                if (!field.hasConstant()) continue;
                switch (field.getType().getSystemID()) {
                    case 6: {
                        value = "" + (field.getPrimitiveConstantValue() != 0L);
                        break;
                    }
                    case 7: {
                        value = "" + (byte)field.getPrimitiveConstantValue();
                        break;
                    }
                    case 8: {
                        value = "" + (char)field.getPrimitiveConstantValue();
                        break;
                    }
                    case 9: {
                        value = "" + (short)field.getPrimitiveConstantValue();
                        break;
                    }
                    case 10: {
                        value = "" + (int)field.getPrimitiveConstantValue();
                        break;
                    }
                    case 11: {
                        value = "JLONG_CONSTANT(" + field.getPrimitiveConstantValue() + ")";
                        break;
                    }
                    case 14: {
                        value = "" + Double.longBitsToDouble(field.getPrimitiveConstantValue());
                        break;
                    }
                    case 13: {
                        value = "" + Float.intBitsToFloat((int)field.getPrimitiveConstantValue());
                        break;
                    }
                    case 2: {
                        continue block33;
                    }
                    default: {
                        throw new RuntimeException("need another case statement for constants of type " + field.getType().getName());
                    }
                }
                String name2 = CHeaderFileCreator.fix(klass.getName() + '_' + field.getName());
                if (name2.startsWith("com_sun_squawk_vm_")) {
                    name2 = name2.substring("com_sun_squawk_vm_".length());
                }
                out.println("#define " + name2 + " " + value);
            }
        }
        this.verifyFieldOffsets();
        this.verifyMethodOffsets();
        int i = 0;
        while ((name = this.getStringProperty("ENTRYPOINT." + i + ".NAME")) != null) {
            int addr = this.getIntProperty("ENTRYPOINT." + i + ".ADDRESS");
            out.println("#define " + name + " Address_add(com_sun_squawk_VM_romStart, " + addr + ")");
            ++i;
        }
        out.println("const char *AddressType_Mnemonics = \"-ZbBSIFLlDdRU\";");
        out.println("#if TRACE");
        out.println("char *getOpcodeName(int code) {");
        out.println("    switch(code) {");
        try {
            i = 0;
            while (true) {
                out.println("        case " + i + ": return \"" + Mnemonics.getMnemonic((int)i) + "\";");
                ++i;
            }
        }
        catch (IndexOutOfBoundsException e) {
            out.println("        default: return \"Unknown opcode\";");
            out.println("    }");
            out.println("}");
            out.println("boolean opcodeHasWide(int code) {");
            out.println("    switch(code) {");
            try {
                i = 0;
                while (true) {
                    if (OPC.hasWide((int)i)) {
                        String mnemonic = Mnemonics.getMnemonic((int)i).toUpperCase();
                        out.println("        case OPC_" + mnemonic + ":");
                    }
                    ++i;
                }
            }
            catch (IndexOutOfBoundsException e2) {
                String name3;
                out.println("                 return true;");
                out.println("        default: return false;");
                out.println("    }");
                out.println("}");
                Hashtable globalAddrs = InstructionEmitter.getGlobalAddrVariables();
                Hashtable globalInts = InstructionEmitter.getGlobalIntVariables();
                Hashtable globalOops = InstructionEmitter.getGlobalOopVariables();
                this.outputGlobalNames(out, globalAddrs, "getGlobalAddrName");
                this.outputGlobalNames(out, globalOops, "getGlobalOopName");
                this.outputGlobalNames(out, globalInts, "getGlobalIntName");
                out.println("#endif");
                for (Map.Entry entry : globalInts.entrySet()) {
                    name3 = (String)entry.getKey();
                    int offset = (Integer)entry.getValue();
                    name3 = name3.replace('.', '_');
                    out.println("#define " + name3 + " (Ints[" + offset + "])");
                }
                for (Map.Entry entry : globalAddrs.entrySet()) {
                    name3 = (String)entry.getKey();
                    int offset = (Integer)entry.getValue();
                    name3 = name3.replace('.', '_');
                    out.println("#define " + name3 + " (Addrs[" + offset + "])");
                }
                for (Map.Entry entry : globalOops.entrySet()) {
                    name3 = (String)entry.getKey();
                    int offset = (Integer)entry.getValue();
                    name3 = name3.replace('.', '_');
                    out.println("#define " + name3 + " (Oops[" + offset + "])");
                }
                out.println("#define ROM_BIG_ENDIAN " + this.getStringProperty("PMR.BIG_ENDIAN"));
                out.println("#define ROM_REVERSE_PARAMETERS " + this.getStringProperty("PMR.REVERSE_PARAMETERS"));
                out.println("#define ROM_GLOBAL_INT_COUNT  " + this.getIntProperty("ROM.GLOBAL.INT.COUNT"));
                out.println("#define ROM_GLOBAL_OOP_COUNT  " + this.getIntProperty("ROM.GLOBAL.OOP.COUNT"));
                out.println("#define ROM_GLOBAL_ADDR_COUNT " + this.getIntProperty("ROM.GLOBAL.ADDR.COUNT"));
                out.close();
                return;
            }
        }
    }

    private static String fix(String str) {
        str = str.replace('.', '_');
        if ((str = str.replace('$', '_')).indexOf(95) == -1) {
            str = str.toUpperCase();
        }
        return str;
    }

    private String getStringProperty(String name) {
        return this.map.getProperty(name);
    }

    private int getIntProperty(String name) {
        try {
            return Integer.parseInt(this.getStringProperty(name));
        }
        catch (NumberFormatException ex) {
            throw new RuntimeException("in getIntProperty(" + name + ") = " + this.getStringProperty(name));
        }
    }
}

