/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.Field;
import com.sun.squawk.Klass;
import com.sun.squawk.UWord;
import com.sun.squawk.util.Assert;

public class FieldReflector {
    private FieldReflector() {
    }

    private static java.lang.reflect.Field jvmField(Field field) throws Exception {
        Klass klass = field.getDefiningClass();
        String name = klass.getName();
        Class<?> clazz = Class.forName(name);
        java.lang.reflect.Field jvmField = clazz.getDeclaredField(name = field.getName());
        if (!jvmField.isAccessible()) {
            jvmField.setAccessible(true);
        }
        return jvmField;
    }

    public static int getByte(Object object, Field field) {
        try {
            java.lang.reflect.Field jvmField = FieldReflector.jvmField(field);
            if (jvmField.getType() == Boolean.TYPE) {
                return (byte)(jvmField.getBoolean(object) ? 1 : 0);
            }
            return jvmField.getByte(object);
        }
        catch (Exception ex) {
            Assert.shouldNotReachHere();
            return 0;
        }
    }

    public static int getShort(Object object, Field field) {
        try {
            return FieldReflector.jvmField(field).getShort(object);
        }
        catch (Exception ex) {
            Assert.shouldNotReachHere();
            return 0;
        }
    }

    public static int getChar(Object object, Field field) {
        try {
            return FieldReflector.jvmField(field).getChar(object);
        }
        catch (Exception ex) {
            Assert.shouldNotReachHere();
            return 0;
        }
    }

    public static int getInt(Object object, Field field) {
        try {
            java.lang.reflect.Field jvmField = FieldReflector.jvmField(field);
            if (jvmField.getType() == Float.TYPE) {
                return Float.floatToIntBits(jvmField.getFloat(object));
            }
            return jvmField.getInt(object);
        }
        catch (Exception ex) {
            Assert.shouldNotReachHere();
            return 0;
        }
    }

    public static long getLong(Object object, Field field) {
        try {
            java.lang.reflect.Field jvmField = FieldReflector.jvmField(field);
            if (jvmField.getType() == Double.TYPE) {
                return Double.doubleToLongBits(jvmField.getDouble(object));
            }
            return jvmField.getLong(object);
        }
        catch (Exception ex) {
            Assert.shouldNotReachHere();
            return 0L;
        }
    }

    public static Object getObject(Object object, Field field) {
        try {
            return FieldReflector.jvmField(field).get(object);
        }
        catch (Exception ex) {
            Assert.shouldNotReachHere();
            return null;
        }
    }

    public static UWord getUWord(Object object, Field field) {
        try {
            return (UWord)FieldReflector.jvmField(field).get(object);
        }
        catch (Exception ex) {
            Assert.shouldNotReachHere();
            return null;
        }
    }

    public static int getConstantInt(Field field) {
        try {
            return FieldReflector.jvmField(field).getInt(null);
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public static byte getConstantByte(Field field) {
        try {
            return FieldReflector.jvmField(field).getByte(null);
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public static long getConstantLong(Field field) {
        try {
            return FieldReflector.jvmField(field).getLong(null);
        }
        catch (Exception ex) {
            return -1L;
        }
    }
}

