/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.Address;
import com.sun.squawk.GC;
import com.sun.squawk.Isolate;
import com.sun.squawk.Klass;
import com.sun.squawk.KlassMetadata;
import com.sun.squawk.MethodBody;
import com.sun.squawk.NativeUnsafe;
import com.sun.squawk.ObjectGraphSerializer;
import com.sun.squawk.ObjectMemory;
import com.sun.squawk.ObjectMemoryLoader;
import com.sun.squawk.Suite;
import com.sun.squawk.TranslatorInterface;
import com.sun.squawk.UWord;
import com.sun.squawk.VM;
import com.sun.squawk.romizer.ObjectGraphLoaderTranslator;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.UnexpectedException;
import com.sun.squawk.vm.FieldOffsets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Stack;

public class ObjectGraphLoader {
    protected Map<Address, Object> addressToObjectMap = new IdentityHashMap<Address, Object>();
    protected final Stack<Map<Address, Object>> addressToObjectMapStack = new Stack();
    protected Map<Object, Address> objectToAddressMap = new IdentityHashMap<Object, Address>();
    protected final Stack<Map<Object, Address>> objectToAddressMapStack = new Stack();
    protected ObjectGraphLoaderTranslator translator = new ObjectGraphLoaderTranslator();
    protected boolean skipKlassInternals;

    public Map<Object, Address> getObjectToAddressMap() {
        return this.objectToAddressMap;
    }

    protected byte[] getBytesAt(Address address) {
        if (address.isZero()) {
            return null;
        }
        Object object = this.addressToObjectMap.get(address);
        if (object != null) {
            return (byte[])object;
        }
        int length = GC.getArrayLengthNoCheck((Object)address);
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)(NativeUnsafe.getByte((Object)address, (int)i) & 0xFF);
        }
        this.addressToObjectMap.put(address, bytes);
        this.objectToAddressMap.put(bytes, address);
        return bytes;
    }

    protected Klass getKlassAt(Address address) {
        if (address.isZero()) {
            return null;
        }
        Object object = this.addressToObjectMap.get(address);
        if (object != null) {
            return (Klass)object;
        }
        Address nameAddress = NativeUnsafe.getAddress((Object)address, (int)FieldOffsets.decodeOffset((long)0x100000003L));
        String name = this.getStringAt(nameAddress);
        Klass klass = Klass.getClass((String)name, (boolean)false);
        this.addressToObjectMap.put(address, klass);
        this.objectToAddressMap.put(klass, address);
        if (!this.skipKlassInternals) {
            this.initKlassInternals(klass);
        }
        return klass;
    }

    protected void initKlassInternals(Klass klass) {
        Address address = this.objectToAddressMap.get(klass);
        MethodBody[] virtualMethodBodies = this.getMethodBodiesAt(NativeUnsafe.getAddress((Object)address, (int)FieldOffsets.decodeOffset((long)0x100000001L)));
        MethodBody[] staticMethodBodies = this.getMethodBodiesAt(NativeUnsafe.getAddress((Object)address, (int)FieldOffsets.decodeOffset((long)0x100000002L)));
        Klass superType = this.getKlassAt(NativeUnsafe.getAddress((Object)address, (int)FieldOffsets.decodeOffset((long)0x100000005L)));
        Klass[] interfaces = this.getKlassesAt(NativeUnsafe.getAddress((Object)address, (int)FieldOffsets.decodeOffset((long)0x100000006L)));
        UWord[] oopMap = this.getUWordsAt(NativeUnsafe.getAddress((Object)address, (int)FieldOffsets.decodeOffset((long)0x100000009L)));
        UWord oopMapWord = NativeUnsafe.getUWord((Object)address, (int)FieldOffsets.decodeOffset((long)0x10000000AL));
        UWord[] dataMap = this.getUWordsAt(NativeUnsafe.getAddress((Object)address, (int)FieldOffsets.decodeOffset((long)0x10000000BL)));
        UWord dataMapWord = NativeUnsafe.getUWord((Object)address, (int)FieldOffsets.decodeOffset((long)0x10000000CL));
        short dataMapLength = (short)NativeUnsafe.getShort((Object)address, (int)FieldOffsets.decodeOffset((long)38654705692L));
        int modifiers = NativeUnsafe.getInt((Object)address, (int)FieldOffsets.decodeOffset((long)0xA0000000DL));
        byte state = (byte)NativeUnsafe.getByte((Object)address, (int)FieldOffsets.decodeOffset((long)30064771144L));
        short instanceSizeBytes = (short)NativeUnsafe.getShort((Object)address, (int)FieldOffsets.decodeOffset((long)38654705694L));
        short staticFieldsSize = (short)NativeUnsafe.getShort((Object)address, (int)FieldOffsets.decodeOffset((long)38654705695L));
        short refStaticFieldsSize = (short)NativeUnsafe.getShort((Object)address, (int)FieldOffsets.decodeOffset((long)0x900000020L));
        short indexForInit = (short)NativeUnsafe.getShort((Object)address, (int)FieldOffsets.decodeOffset((long)38654705697L));
        short indexForClinit = (short)NativeUnsafe.getShort((Object)address, (int)FieldOffsets.decodeOffset((long)0x900000022L));
        short indexForMain = (short)NativeUnsafe.getShort((Object)address, (int)FieldOffsets.decodeOffset((long)38654705699L));
        byte initModifiers = (byte)NativeUnsafe.getByte((Object)address, (int)FieldOffsets.decodeOffset((long)30064771145L));
        boolean mustClinit = NativeUnsafe.getByte((Object)address, (int)FieldOffsets.decodeOffset((long)30064771146L)) != 0;
        klass.initForObjectGraphLoader(virtualMethodBodies, staticMethodBodies, superType, interfaces, null, oopMap, oopMapWord, dataMap, dataMapWord, dataMapLength, modifiers, state, instanceSizeBytes, staticFieldsSize, refStaticFieldsSize, indexForInit, indexForClinit, indexForMain, initModifiers, mustClinit);
    }

    protected Klass[] getKlassesAt(Address address) {
        if (address.isZero()) {
            return null;
        }
        Object object = this.addressToObjectMap.get(address);
        if (object != null) {
            return (Klass[])object;
        }
        int length = GC.getArrayLengthNoCheck((Object)address);
        Klass[] klasses = new Klass[length];
        for (int i = 0; i < klasses.length; ++i) {
            klasses[i] = this.getKlassAt(NativeUnsafe.getAddress((Object)address, (int)i));
        }
        this.addressToObjectMap.put(address, klasses);
        this.objectToAddressMap.put(klasses, address);
        return klasses;
    }

    protected KlassMetadata getKlassMetadataAt(Address address) {
        if (address.isZero()) {
            return null;
        }
        Object object = this.addressToObjectMap.get(address);
        if (object != null) {
            return (KlassMetadata)object;
        }
        Address definedKlassAddress = NativeUnsafe.getAddress((Object)address, (int)FieldOffsets.decodeOffset((long)0x100000000L));
        Klass definedClass = this.getKlassAt(definedKlassAddress);
        Address symbolsAddress = NativeUnsafe.getAddress((Object)address, (int)FieldOffsets.decodeOffset((long)0x100000001L));
        byte[] symbols = this.getBytesAt(symbolsAddress);
        Address classTableAddress = NativeUnsafe.getAddress((Object)address, (int)FieldOffsets.decodeOffset((long)0x100000002L));
        Klass[] classTable = this.getKlassesAt(classTableAddress);
        KlassMetadata metadata = new KlassMetadata(definedClass, symbols, classTable);
        this.addressToObjectMap.put(address, metadata);
        this.objectToAddressMap.put(metadata, address);
        return metadata;
    }

    protected KlassMetadata[] getKlassMetadatasAt(Address address) {
        if (address.isZero()) {
            return null;
        }
        Object object = this.addressToObjectMap.get(address);
        if (object != null) {
            return (KlassMetadata[])object;
        }
        int length = GC.getArrayLengthNoCheck((Object)address);
        KlassMetadata[] metadatas = new KlassMetadata[length];
        for (int i = 0; i < metadatas.length; ++i) {
            KlassMetadata metadata;
            Address metadataAddress = NativeUnsafe.getAddress((Object)address, (int)i);
            metadatas[i] = metadata = this.getKlassMetadataAt(metadataAddress);
        }
        this.addressToObjectMap.put(address, metadatas);
        this.objectToAddressMap.put(metadatas, address);
        return metadatas;
    }

    protected MethodBody getMethodBodyAt(Address address) {
        if (address.isZero()) {
            return null;
        }
        Object object = this.addressToObjectMap.get(address);
        if (object != null) {
            return (MethodBody)object;
        }
        MethodBody methodBody = new MethodBody();
        this.addressToObjectMap.put(address, methodBody);
        this.objectToAddressMap.put(methodBody, address);
        return methodBody;
    }

    protected MethodBody[] getMethodBodiesAt(Address address) {
        if (address.isZero()) {
            return null;
        }
        Object object = this.addressToObjectMap.get(address);
        if (object != null) {
            return (MethodBody[])object;
        }
        int length = GC.getArrayLengthNoCheck((Object)address);
        MethodBody[] methodBodies = new MethodBody[length];
        for (int i = 0; i < methodBodies.length; ++i) {
            Address methodBodyAddress = NativeUnsafe.getAddress((Object)address, (int)i);
            methodBodies[i] = this.getMethodBodyAt(methodBodyAddress);
        }
        this.addressToObjectMap.put(address, methodBodies);
        this.objectToAddressMap.put(methodBodies, address);
        return methodBodies;
    }

    protected String getStringAt(Address address) {
        if (address.isZero()) {
            return null;
        }
        Object object = this.addressToObjectMap.get(address);
        if (object != null) {
            return (String)object;
        }
        int length = GC.getArrayLengthNoCheck((Object)address);
        Address klassAddress = NativeUnsafe.getAddress((Object)address, (int)-1);
        int classID = NativeUnsafe.getShort((Object)klassAddress, (int)FieldOffsets.decodeOffset((long)38654705693L));
        Assert.that((classID == 2 || classID == 26 ? 1 : 0) != 0);
        StringBuffer buf = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            char ch = classID == 2 ? (char)NativeUnsafe.getChar((Object)address, (int)i) : (char)(NativeUnsafe.getByte((Object)address, (int)i) & 0xFF);
            buf.append(ch);
        }
        String string = buf.toString();
        this.addressToObjectMap.put(address, string);
        this.objectToAddressMap.put(string, address);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Suite loadSuite(String url) throws IOException {
        ObjectMemory objectMemory;
        String bootstrapSuiteProperty = System.getProperty("bootstrap.suite.url");
        if (bootstrapSuiteProperty == null) {
            bootstrapSuiteProperty = "file://squawk.suite";
        }
        if (NativeUnsafe.getMemorySize() == 0) {
            GC.initialize();
        }
        if ((objectMemory = GC.lookupReadOnlyObjectMemoryBySourceURI((String)url)) == null && url.equals(bootstrapSuiteProperty)) {
            objectMemory = GC.lookupReadOnlyObjectMemoryBySourceURI((String)"memory:bootstrap");
        }
        if (objectMemory != null) {
            Assert.that((boolean)(objectMemory.getRoot() instanceof Suite));
            return (Suite)objectMemory.getRoot();
        }
        objectMemory = ObjectMemoryLoader.load((String)url, (boolean)false).objectMemory;
        if (objectMemory == null) {
            throw new IOException("No object memories found with URL: " + url);
        }
        ArrayList<ObjectMemory> objectMemories = new ArrayList<ObjectMemory>();
        while (objectMemory != null) {
            objectMemories.add(0, objectMemory);
            objectMemory = objectMemory.getParent();
        }
        Address allocTop = Address.zero();
        Suite parentSuite = null;
        for (ObjectMemory eachObjectMemory : objectMemories) {
            Object root = eachObjectMemory.getRoot();
            if (root instanceof Address) {
                Suite suite = this.getSuiteAt((Address)root, parentSuite);
                eachObjectMemory.setRoot((Object)suite);
                parentSuite = suite;
                GC.registerReadOnlyObjectMemory((ObjectMemory)eachObjectMemory);
                allocTop = allocTop.add(NativeUnsafe.getMemorySize());
                Address end = eachObjectMemory.getStart().add(eachObjectMemory.getSize());
                Address block = eachObjectMemory.getStart();
                while (block.lo(end)) {
                    Address object = GC.blockToOop((Address)block);
                    Address classOrAssociation = NativeUnsafe.getAddress((Object)object, (int)-1);
                    Assert.that((!classOrAssociation.isZero() ? 1 : 0) != 0);
                    Address klassAddress = NativeUnsafe.getAddress((Object)classOrAssociation, (int)0);
                    Assert.that((!klassAddress.isZero() ? 1 : 0) != 0);
                    Klass klass = this.getKlassAt(klassAddress);
                    if (Klass.STRING.isAssignableFrom(klass)) {
                        this.getStringAt(object);
                    }
                    block = object.add(GC.getBodySize((Klass)klass, (Address)object));
                }
                String metadataUrl = (suite.isBootstrap() ? bootstrapSuiteProperty : eachObjectMemory.getURI()) + ".metadata";
                try {
                    Suite metadataSuite;
                    int memorySizePrior = NativeUnsafe.getMemorySize();
                    ObjectMemory metadataObjectMemory = ObjectMemoryLoader.load((String)metadataUrl, (boolean)false).objectMemory;
                    this.pushObjectMap();
                    try {
                        metadataSuite = this.getSuiteAt((Address)metadataObjectMemory.getRoot(), suite);
                    }
                    finally {
                        this.popObjectMap();
                    }
                    metadataSuite.pushUpMetadatas();
                    NativeUnsafe.setMemorySize((int)memorySizePrior);
                }
                catch (IOException e) {
                    throw new UnexpectedException("Unable to find metadata suite: " + metadataUrl, (Throwable)e);
                }
            }
            if (root instanceof Suite) {
                parentSuite = (Suite)root;
            } else {
                Assert.shouldNotReachHere();
            }
            GC.setAllocTop((Address)allocTop);
        }
        ObjectGraphSerializer.addObjectsToAddress(this.getObjectToAddressMap());
        return parentSuite;
    }

    protected Suite getSuiteAt(Address address, Suite parent) {
        KlassMetadata[] metadatas;
        if (address.isZero()) {
            return null;
        }
        Object object = this.addressToObjectMap.get(address);
        if (object != null) {
            return (Suite)object;
        }
        String name = this.getStringAt(NativeUnsafe.getAddress((Object)address, (int)FieldOffsets.decodeOffset((long)0x100000001L)));
        Suite suite = new Suite(name, parent);
        VM.setCurrentIsolate(null);
        Isolate isolate = new Isolate(null, null, suite);
        isolate.setTranslator((TranslatorInterface)this.translator);
        VM.setCurrentIsolate(isolate);
        this.translator.setInKlassInit(true);
        Klass.getClass((String)"-null-", (boolean)false);
        this.translator.setInKlassInit(false);
        this.skipKlassInternals = true;
        Klass[] klasses = this.getKlassesAt(NativeUnsafe.getAddress((Object)address, (int)FieldOffsets.decodeOffset((long)0x100000000L)));
        this.skipKlassInternals = false;
        for (int i = 0; i < klasses.length; ++i) {
            Klass klass = klasses[i];
            this.initKlassInternals(klass);
            Assert.that((suite.getKlass(i) == klass ? 1 : 0) != 0);
        }
        for (KlassMetadata metadata : metadatas = this.getKlassMetadatasAt(NativeUnsafe.getAddress((Object)address, (int)FieldOffsets.decodeOffset((long)0x100000002L)))) {
            if (metadata == null) continue;
            suite.installMetadata(metadata);
        }
        this.addressToObjectMap.put(address, suite);
        this.objectToAddressMap.put(suite, address);
        return suite;
    }

    protected UWord[] getUWordsAt(Address address) {
        if (address.isZero()) {
            return null;
        }
        Object object = this.addressToObjectMap.get(address);
        if (object != null) {
            return (UWord[])object;
        }
        int length = GC.getArrayLengthNoCheck((Object)address);
        UWord[] uwords = new UWord[length];
        for (int i = 0; i < length; ++i) {
            uwords[i] = NativeUnsafe.getUWord((Object)address, (int)i);
        }
        this.addressToObjectMap.put(address, uwords);
        this.objectToAddressMap.put(uwords, address);
        return uwords;
    }

    protected void popObjectMap() {
        this.addressToObjectMap = this.addressToObjectMapStack.pop();
        this.objectToAddressMap = this.objectToAddressMapStack.pop();
    }

    protected void pushObjectMap() {
        this.addressToObjectMapStack.push(this.addressToObjectMap);
        this.addressToObjectMap = new IdentityHashMap<Address, Object>(this.addressToObjectMap);
        this.objectToAddressMapStack.push(this.objectToAddressMap);
        this.objectToAddressMap = new IdentityHashMap<Object, Address>(this.objectToAddressMap);
    }
}

