/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.Address;
import com.sun.squawk.Field;
import com.sun.squawk.FieldReflector;
import com.sun.squawk.GC;
import com.sun.squawk.Klass;
import com.sun.squawk.KlassMetadata;
import com.sun.squawk.MethodBody;
import com.sun.squawk.NativeUnsafe;
import com.sun.squawk.ObjectMemorySerializer;
import com.sun.squawk.Romizer;
import com.sun.squawk.Suite;
import com.sun.squawk.UWord;
import com.sun.squawk.VM;
import com.sun.squawk.util.ArrayHashtable;
import com.sun.squawk.util.Assert;
import com.sun.squawk.util.BitSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public final class ObjectGraphSerializer {
    private static int entryPointCounter = 0;
    private static final Map<Class<?>, Klass> classKlassMap = new HashMap();
    private static ArrayHashtable objectMap = new ArrayHashtable();
    private static final Stack<ArrayHashtable> objectMapStack = new Stack();
    private static boolean inAlloc = false;
    private static int saveDepth;
    private static final boolean VERBOSE = false;

    private static void traceAllocation(Klass klass, Object object, Address serializedObject) {
    }

    public static ObjectMemorySerializer.ControlBlock serialize(Object object) {
        int currentMemorySize = NativeUnsafe.getMemorySize();
        Address start = Address.fromPrimitive((int)currentMemorySize);
        if (currentMemorySize == 0) {
            GC.initialize();
        }
        ObjectGraphSerializer.save(object);
        NativeUnsafe.resolveClasses((ArrayHashtable)objectMap);
        ObjectMemorySerializer.ControlBlock cb = new ObjectMemorySerializer.ControlBlock();
        cb.root = ((Address)objectMap.get(object)).diff(start).toInt();
        int size = NativeUnsafe.getMemorySize() - currentMemorySize;
        cb.start = start;
        cb.memory = new byte[size];
        NativeUnsafe.copyMemory((byte[])cb.memory, (int)currentMemorySize, (int)0, (int)size);
        cb.oopMap = new BitSet();
        cb.oopMap.or(NativeUnsafe.getOopMap(), -currentMemorySize / 4);
        return cb;
    }

    public static void popObjectMap() {
        objectMap = objectMapStack.pop();
    }

    public static void pushObjectMap() {
        objectMapStack.push(objectMap);
        objectMap = new ArrayHashtable(objectMap);
    }

    private static String getKlassName(Class<?> c) {
        if (c.isArray()) {
            return "[" + ObjectGraphSerializer.getKlassName(c.getComponentType());
        }
        return c.getName();
    }

    private static Klass classToKlass(Class<?> cls) {
        Klass klass = classKlassMap.get(cls);
        if (klass == null) {
            String name = ObjectGraphSerializer.getKlassName(cls);
            Suite suite = VM.getCurrentIsolate().getLeafSuite();
            klass = suite.lookup(name);
            Assert.that((klass != null ? 1 : 0) != 0, (String)("Lookup failure for class " + name));
            if (!klass.isSynthetic() && !klass.isArray()) {
                KlassMetadata metadata = VM.getCurrentIsolate().getLeafSuite().getMetadata(klass);
                Assert.always((metadata != null ? 1 : 0) != 0, (String)("Must have metadata to save instances of type: " + name));
            }
            classKlassMap.put(cls, klass);
        }
        return klass;
    }

    private static Object alloc(Object object, Klass klass, int length) {
        Object serializedObject;
        Assert.that((!inAlloc ? 1 : 0) != 0);
        inAlloc = true;
        if (klass.isArray()) {
            serializedObject = GC.newArray((Klass)klass, (int)length);
        } else if (klass == Klass.STRING) {
            serializedObject = GC.newArray((Klass)Klass.CHAR_ARRAY, (int)length);
            GC.setHeaderClass((Address)((Address)serializedObject), (Object)Klass.STRING);
        } else if (klass == Klass.STRING_OF_BYTES) {
            serializedObject = GC.newArray((Klass)Klass.BYTE_ARRAY, (int)length);
            GC.setHeaderClass((Address)((Address)serializedObject), (Object)Klass.STRING_OF_BYTES);
        } else if (object instanceof MethodBody) {
            MethodBody mbody = (MethodBody)object;
            Klass definingClass = mbody.getDefiningClass();
            serializedObject = GC.newMethod((Object)definingClass, (MethodBody)mbody);
            if (definingClass.getName().equals("com.sun.squawk.VM")) {
                String methodName = mbody.getDefiningMethod().getName();
                if (mbody.getDefiningMethod().isInterpreterInvoked()) {
                    int old = VM.setStream(2);
                    VM.println("ENTRYPOINT." + entryPointCounter + ".NAME=com_sun_squawk_VM_" + methodName);
                    VM.println("ENTRYPOINT." + entryPointCounter + ".ADDRESS=" + serializedObject);
                    ++entryPointCounter;
                    VM.setStream(old);
                }
            }
        } else {
            serializedObject = GC.newInstance((Klass)klass);
        }
        Object previous = objectMap.put(object, serializedObject);
        Assert.that((previous == null ? 1 : 0) != 0);
        ObjectGraphSerializer.traceAllocation(klass, object, Address.fromObject((Object)serializedObject));
        inAlloc = false;
        return serializedObject;
    }

    public static void addObjectsToAddress(ArrayHashtable hashtable) {
        Enumeration keys = hashtable.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            objectMap.put(key, hashtable.get(key));
        }
    }

    public static void addObjectsToAddress(Map<Object, Address> objectToAddressMap) {
        for (Map.Entry<Object, Address> entry : objectToAddressMap.entrySet()) {
            objectMap.put(entry.getKey(), (Object)entry.getValue());
        }
    }

    private static boolean isEightBitEnc(char[] chars) {
        int length = chars.length;
        for (int i = 0; i < length; ++i) {
            if (chars[i] <= '\u00ff') continue;
            return false;
        }
        return true;
    }

    private static Object save(Object object) {
        return ObjectGraphSerializer.save(object, ObjectGraphSerializer.classToKlass(object.getClass()));
    }

    private static Object save(Object object, Klass klass) {
        Object serializedObject;
        block32: {
            block33: {
                serializedObject = objectMap.get(object);
                if (serializedObject != null) break block32;
                if (!klass.isSquawkArray()) break block33;
                switch (klass.getSystemID()) {
                    case 18: {
                        boolean[] array = (boolean[])object;
                        serializedObject = ObjectGraphSerializer.alloc(object, klass, array.length);
                        for (int i = 0; i < array.length; ++i) {
                            NativeUnsafe.setByte((Object)serializedObject, (int)i, (int)(array[i] ? 1 : 0));
                        }
                        break block32;
                    }
                    case 19: {
                        byte[] array = (byte[])object;
                        serializedObject = ObjectGraphSerializer.alloc(object, klass, array.length);
                        for (int i = 0; i < array.length; ++i) {
                            NativeUnsafe.setByte((Object)serializedObject, (int)i, (int)array[i]);
                        }
                        break block32;
                    }
                    case 21: {
                        short[] array = (short[])object;
                        serializedObject = ObjectGraphSerializer.alloc(object, klass, array.length);
                        for (int i = 0; i < array.length; ++i) {
                            NativeUnsafe.setShort((Object)serializedObject, (int)i, (int)array[i]);
                        }
                        break block32;
                    }
                    case 20: {
                        char[] array = (char[])object;
                        serializedObject = ObjectGraphSerializer.alloc(object, klass, array.length);
                        for (int i = 0; i < array.length; ++i) {
                            NativeUnsafe.setChar((Object)serializedObject, (int)i, (int)array[i]);
                        }
                        break block32;
                    }
                    case 26: {
                        char[] value = ((String)object).toCharArray();
                        serializedObject = ObjectGraphSerializer.alloc(object, Klass.STRING_OF_BYTES, value.length);
                        for (int i = 0; i != value.length; ++i) {
                            NativeUnsafe.setByte((Object)serializedObject, (int)i, (int)((byte)value[i]));
                        }
                        break block32;
                    }
                    case 2: {
                        String str = (String)object;
                        char[] value = str.toCharArray();
                        if (ObjectGraphSerializer.isEightBitEnc(value)) {
                            boolean done = false;
                            while (!done) {
                                done = true;
                                String buildProp = "${build.properties:";
                                int start = str.indexOf(buildProp);
                                if (start >= 0) {
                                    String head = str.substring(0, start);
                                    String rest = str.substring(start);
                                    int end = rest.indexOf(125);
                                    Assert.that((end > 0 ? 1 : 0) != 0);
                                    String symbol = rest.substring(buildProp.length(), end);
                                    String tail = rest.substring(end + 1);
                                    String prop = Romizer.getBuildProperty(symbol);
                                    if (prop == null) {
                                        throw new RuntimeException("Cannot find build property: " + symbol);
                                    }
                                    str = head + prop + tail;
                                    done = false;
                                }
                                object = str;
                            }
                            return ObjectGraphSerializer.save(object, Klass.STRING_OF_BYTES);
                        }
                        serializedObject = ObjectGraphSerializer.alloc(object, Klass.STRING, value.length);
                        for (int i = 0; i != value.length; ++i) {
                            NativeUnsafe.setChar((Object)serializedObject, (int)i, (int)value[i]);
                        }
                        break block32;
                    }
                    case 22: {
                        int[] array = (int[])object;
                        serializedObject = ObjectGraphSerializer.alloc(object, klass, array.length);
                        for (int i = 0; i < array.length; ++i) {
                            NativeUnsafe.setInt((Object)serializedObject, (int)i, (int)array[i]);
                        }
                        break block32;
                    }
                    case 37: {
                        UWord[] array = (UWord[])object;
                        serializedObject = ObjectGraphSerializer.alloc(object, klass, array.length);
                        for (int i = 0; i < array.length; ++i) {
                            NativeUnsafe.setUWord((Object)serializedObject, (int)i, (UWord)array[i]);
                        }
                        break block32;
                    }
                    case 24: {
                        float[] array = (float[])object;
                        serializedObject = ObjectGraphSerializer.alloc(object, klass, array.length);
                        for (int i = 0; i < array.length; ++i) {
                            NativeUnsafe.setInt((Object)serializedObject, (int)i, (int)Float.floatToIntBits(array[i]));
                        }
                        break block32;
                    }
                    case 23: {
                        long[] array = (long[])object;
                        serializedObject = ObjectGraphSerializer.alloc(object, klass, array.length);
                        for (int i = 0; i < array.length; ++i) {
                            NativeUnsafe.setLong((Object)serializedObject, (int)i, (long)array[i]);
                        }
                        break block32;
                    }
                    case 25: {
                        double[] array = (double[])object;
                        serializedObject = ObjectGraphSerializer.alloc(object, klass, array.length);
                        for (int i = 0; i < array.length; ++i) {
                            NativeUnsafe.setLong((Object)serializedObject, (int)i, (long)Double.doubleToLongBits(array[i]));
                        }
                        break block32;
                    }
                    case 29: 
                    case 30: {
                        Assert.shouldNotReachHere();
                        break;
                    }
                    default: {
                        Assert.that((boolean)Klass.OBJECT_ARRAY.isAssignableFrom(klass));
                        Object[] array = (Object[])object;
                        serializedObject = ObjectGraphSerializer.alloc(object, klass, array.length);
                        for (int i = 0; i < array.length; ++i) {
                            Object value = array[i];
                            Object serializedValue = Address.zero();
                            if (value != null) {
                                serializedValue = ObjectGraphSerializer.save(value);
                            }
                            NativeUnsafe.setObject((Object)serializedObject, (int)i, (Object)serializedValue);
                        }
                        break block32;
                    }
                }
                break block32;
            }
            ++saveDepth;
            serializedObject = ObjectGraphSerializer.alloc(object, klass, -1);
            if (!(object instanceof MethodBody)) {
                ObjectGraphSerializer.saveFields(object, serializedObject);
            }
            --saveDepth;
        }
        return serializedObject;
    }

    private static void saveFields(Object object, Object serializedObject) {
        for (Klass klass = ObjectGraphSerializer.classToKlass(object.getClass()); klass != Klass.OBJECT; klass = klass.getSuperclass()) {
            ObjectGraphSerializer.saveDeclaredFields(object, serializedObject, klass);
        }
    }

    private static void saveDeclaredFields(Object object, Object serializedObject, Klass klass) {
        int count = klass.getFieldCount(false);
        block8: for (int i = 0; i < count; ++i) {
            Field field = klass.getField(i, false);
            Klass type = field.getType();
            switch (type.getSystemID()) {
                case 6: 
                case 7: {
                    int value = FieldReflector.getByte(object, field);
                    NativeUnsafe.setByte((Object)serializedObject, (int)field.getOffset(), (int)value);
                    continue block8;
                }
                case 9: {
                    int value = FieldReflector.getShort(object, field);
                    NativeUnsafe.setShort((Object)serializedObject, (int)field.getOffset(), (int)value);
                    continue block8;
                }
                case 8: {
                    int value = FieldReflector.getChar(object, field);
                    NativeUnsafe.setChar((Object)serializedObject, (int)field.getOffset(), (int)value);
                    continue block8;
                }
                case 10: 
                case 13: {
                    int value = FieldReflector.getInt(object, field);
                    NativeUnsafe.setInt((Object)serializedObject, (int)field.getOffset(), (int)value);
                    continue block8;
                }
                case 11: 
                case 14: {
                    long value = FieldReflector.getLong(object, field);
                    NativeUnsafe.setLongAtWord((Object)serializedObject, (int)field.getOffset(), (long)value);
                    continue block8;
                }
                case 36: {
                    UWord value = FieldReflector.getUWord(object, field);
                    NativeUnsafe.setUWord((Object)serializedObject, (int)field.getOffset(), (UWord)value);
                    continue block8;
                }
                default: {
                    Object value = FieldReflector.getObject(object, field);
                    Object serializedValue = Address.zero();
                    if (value != null) {
                        serializedValue = ObjectGraphSerializer.save(value);
                    }
                    NativeUnsafe.setObject((Object)serializedObject, (int)field.getOffset(), (Object)serializedValue);
                    continue block8;
                }
            }
        }
    }

    private ObjectGraphSerializer() {
    }
}

