/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.Address;
import com.sun.squawk.CHeaderFileCreator;
import com.sun.squawk.Field;
import com.sun.squawk.GC;
import com.sun.squawk.Isolate;
import com.sun.squawk.Klass;
import com.sun.squawk.KlassMetadata;
import com.sun.squawk.Method;
import com.sun.squawk.MethodMetadata;
import com.sun.squawk.NativeUnsafe;
import com.sun.squawk.ObjectGraphLoader;
import com.sun.squawk.ObjectGraphSerializer;
import com.sun.squawk.ObjectMemory;
import com.sun.squawk.ObjectMemoryLoader;
import com.sun.squawk.ResourceFile;
import com.sun.squawk.Suite;
import com.sun.squawk.SymbolParser;
import com.sun.squawk.TranslatorInterface;
import com.sun.squawk.VM;
import com.sun.squawk.io.connections.ClasspathConnection;
import com.sun.squawk.translator.Translator;
import com.sun.squawk.translator.VerifyError;
import com.sun.squawk.translator.ir.InstructionEmitter;
import com.sun.squawk.util.ArgsUtilities;
import com.sun.squawk.util.ComputationTimer;
import com.sun.squawk.util.Tracer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.microedition.io.Connector;

public class Romizer {
    protected static Properties buildProperties;
    private static String buildDotOverrideFileName;
    private String suiteName;
    private Suite suite;
    private String classPath;
    private String java5ClassPath;
    private Romizer parent;
    private Vector<String> generatedFiles = new Vector();
    private int suiteType;
    private Vector<String> excludes;
    private boolean createJars;
    private boolean createMetadata = true;
    private static boolean timer;
    private static boolean stats;
    private TranslatorInterface protoTranslator;
    protected String lastClassName;
    protected List<String> noClassDefFoundErrorClasses = new ArrayList<String>();
    protected HashMap<String, String> jadProperties = new HashMap();
    protected ObjectGraphLoader objectGraphLoader;

    static String getBuildProperty(String key) {
        if (buildProperties == null) {
            Romizer.initBuildProperties();
        }
        return buildProperties.getProperty(key);
    }

    static String getBuildProperty(String key, String ifNotThereValue) {
        if (buildProperties == null) {
            Romizer.initBuildProperties();
        }
        return buildProperties.getProperty(key, ifNotThereValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void initBuildProperties() {
        buildProperties = new Properties();
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream("build.properties");
            buildProperties.load(inputStream);
        }
        catch (IOException ex) {
            throw new Error("Could not find build.properties");
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                inputStream = null;
            }
        }
        try {
            File overideProperties;
            if (buildDotOverrideFileName == null) {
                buildDotOverrideFileName = "build.override";
            }
            if ((overideProperties = new File(buildDotOverrideFileName)).exists()) {
                System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>> Using build override file: " + overideProperties.getPath() + " <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
                inputStream = new FileInputStream(overideProperties);
                buildProperties.load(inputStream);
            }
        }
        catch (IOException ex) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
                inputStream = null;
            }
        }
    }

    static void putBuildProperty(String key, String value) {
        if (buildProperties == null) {
            Romizer.initBuildProperties();
        }
        buildProperties.put(key, value);
    }

    private Romizer(Romizer parent) {
        if (parent != null) {
            this.suiteType = parent.suiteType;
            this.parent = parent;
        } else {
            this.suiteType = 1;
        }
        this.protoTranslator = new Translator();
        this.objectGraphLoader = new ObjectGraphLoader();
    }

    private void usage(String errMsg) {
        PrintStream out = System.out;
        if (errMsg != null) {
            out.println("**** " + errMsg + " ****");
        }
        out.println("Usage: romize [-options] classnames|dirnames|jarfiles...");
        out.println("where options include:");
        out.println();
        out.println("    -cp:<directories and jar/zip files separated by '" + File.pathSeparatorChar + "'>");
        out.println("                        paths where classes and sources can be found (required)");
        out.println("    -suitepath:<directories separated by '" + File.pathSeparatorChar + "'>");
        out.println("                        path where suite files can be found");
        out.println("    -o:<name>           name of suite to generate (required)");
        out.println("    -boot:<name>        name of suite to to use for references to memory:bootstrap suite URL (default=file://squawk.suite)");
        out.println("    -parent:<name>      name of suite to use as the parent of the suite being built");
        out.println("    -metadata           create matching metadata suite (default)");
        out.println("    -nometadata         do not create matching metadata suite");
        out.println("    -jars               create <suite_name>_classes.jar which contains the class files");
        out.println("                        from which the suite was built");
        out.println("    -exclude:<file>     excludes classes that match the class names or packages");
        out.println("                        in file ('<name>.exclude' is used implicitly)");
        out.println("    -noclassdeffounderrorclass:<class name>    This class should cause a NoClassDefFoundError at runtime");
        out.println("    -endian:<value>     endianess ('big' or 'little') for generated suite (required)");
        out.println("    -arch:<name>        base name for dynamic compiler. Full name will be");
        out.println("                        \"com.sun.squawk.compiler.<name>Compiler\"");
        out.println("    -override:<file>     file to use to override the build.properties file found locally, defaults to build.override");
        out.println("    -nobuildproperties   do not load build.propeties");
        this.protoTranslator.printOptionProperties(out, true);
        out.println("    -strip:<t>          strip symbolic information according to <t>:");
        out.println("                           'd' - debug: retain all symbolic info");
        out.println("                           'a' - application: discard all symbolic info");
        out.println("                           'l' - library (default): discard symbolic info");
        out.println("                                 for private/package-private fields and methods");
        out.println("                           'e' - extendable library: discard symbolic info");
        out.println("                                 for private fields and methods");
        out.println("    -lnt                retain line number tables");
        out.println("    -lvt                retain local variable tables");
        out.println("    -timer              print various phase timing statistics");
        out.println("    -verbose, -v        provide more output while running");
        out.println("    -stats              print various translation statistics");
        out.println("    -key:<name>         set key to add to suite's JAD properties");
        out.println("                        must be followed by -value: option");
        out.println("    -value:<name>       set value to add to suite's JAD properties");
        out.println("                        must be preceded by -key: option");
        this.protoTranslator.printTraceFlags(out);
        out.println("    -h                  show this help message and exit");
        out.println();
        out.println();
        out.println("More than one suite can be created by separating the arguments for each");
        out.println("suite with '--'. For example:");
        out.println();
        out.println("  romize -o:squawk -cp:cldc/j2meclasses cldc/j2meclasses -- -cp:translator/j2meclasses -o:translator translator/j2meclasses");
        out.println();
    }

    private static Vector<String> readExcludesFile(String file) {
        Vector lines = new Vector();
        ArgsUtilities.readLines((String)file, lines);
        Vector<String> excludes = new Vector<String>(lines.size());
        for (String line : lines) {
            if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
            int index = line.indexOf(32);
            if (index != -1) {
                String predicate = line.substring(0, index);
                line = line.substring(index + 1);
                String value = "false";
                index = predicate.indexOf(61);
                boolean doNotOfPredicate = false;
                if (index != -1) {
                    value = predicate.substring(index + 1);
                    if (predicate.indexOf("!=") == index - 1) {
                        --index;
                        doNotOfPredicate = true;
                    }
                    predicate = predicate.substring(0, index);
                }
                boolean predicateTrue = Romizer.getBuildProperty(predicate, "false").equals(value);
                if (doNotOfPredicate) {
                    boolean bl = predicateTrue = !predicateTrue;
                }
                if (!predicateTrue) continue;
                while (line.charAt(0) == ' ') {
                    line = line.substring(1);
                }
            }
            excludes.addElement(line);
        }
        return excludes;
    }

    public static void main(String[] args) throws IOException {
        Romizer romizer = null;
        ArrayList<String> classNames = new ArrayList<String>();
        String[] argsLeft = args;
        while (true) {
            try {
                String[] newArgsLeft = new String[argsLeft.length + classNames.size()];
                System.arraycopy(argsLeft, 0, newArgsLeft, classNames.size(), argsLeft.length);
                argsLeft = newArgsLeft;
                int i = 0;
                for (String className : classNames) {
                    argsLeft[i++] = "-noclassdeffounderrorclass:" + className;
                }
                while (argsLeft != null) {
                    romizer = new Romizer(romizer);
                    argsLeft = romizer.run(argsLeft);
                }
                return;
            }
            catch (NoClassDefFoundError e) {
                if (romizer != null && romizer.getLastClassName() != null) {
                    classNames.add(romizer.getLastClassName());
                    System.err.println("WARNING: Deferring Errors:");
                    System.out.println("   " + e.getClass().getSimpleName() + ": " + romizer.getLastClassName());
                    System.out.println("   message: " + e.getLocalizedMessage());
                    System.out.println("   possibly in class: " + romizer.getLastClassName());
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    private String[] run(String[] args) {
        if (args.length == 0) {
            this.usage(null);
            return null;
        }
        try {
            args = ArgsUtilities.expandArgFiles((String[])args);
            final Vector<String> classNames = new Vector<String>();
            Vector<ResourceFile> resources = new Vector<ResourceFile>();
            args = this.processSuiteArgs(args, classNames, resources);
            if (args == null && this.suite == null) {
                return null;
            }
            ComputationTimer.time((String)"translating", (ComputationTimer.ComputationException)new ComputationTimer.ComputationException(){

                public Object run() throws Exception {
                    Romizer.this.translate(classNames);
                    return null;
                }
            });
            int maxI = resources.size();
            for (int i = 0; i < maxI; ++i) {
                ResourceFile resourceFile = resources.elementAt(i);
                System.out.println("[Including resource: " + resourceFile.name + "]");
                this.suite.installResource(resourceFile);
            }
            for (String key : this.jadProperties.keySet()) {
                String value = this.jadProperties.get(key);
                this.suite.setProperty(key, value);
            }
            ComputationTimer.time((String)"suite file creation", (ComputationTimer.ComputationException)new ComputationTimer.ComputationException(){

                public Object run() throws Exception {
                    Romizer.this.createImage();
                    return null;
                }
            });
            if (this.suite.getParent() == null) {
                ComputationTimer.time((String)"rom header creation", (ComputationTimer.ComputationException)new ComputationTimer.ComputationException(){

                    public Object run() throws Exception {
                        Romizer.this.createCHeader();
                        return null;
                    }
                });
            }
            ComputationTimer.time((String)(this.suiteName + ".api creation"), (ComputationTimer.ComputationException)new ComputationTimer.ComputationException(){

                public Object run() throws Exception {
                    Romizer.this.createSuiteAPI();
                    return null;
                }
            });
            if (timer) {
                ComputationTimer.dump((PrintStream)System.out);
                ComputationTimer.reset();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        if (stats) {
            InstructionEmitter.printStats();
        }
        System.out.print("Romizer processed " + this.suite.getClassCount() + " classes and generated " + this.generatedFiles.size() + " files");
        if (VM.isVerbose()) {
            System.out.println(":");
            for (String name : this.generatedFiles) {
                System.out.println("  " + name);
            }
        } else {
            System.out.println(".");
        }
        return args;
    }

    private String[] processSuiteArgs(String[] args, Vector<String> classNames, Vector<ResourceFile> resources) {
        String classArg;
        File file;
        String arg;
        int argc;
        String excludeFile = null;
        Suite parentSuite = this.parent == null ? null : this.parent.suite;
        String key = null;
        for (argc = 0; argc != args.length && (arg = args[argc]) != null && arg.charAt(0) == '-'; ++argc) {
            String suiteUrl;
            if (arg.startsWith("-D")) {
                try {
                    String name = arg.substring("-D".length(), arg.indexOf(61));
                    String value = arg.substring(arg.indexOf(61) + 1);
                    Romizer.putBuildProperty(name, value);
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    this.usage("malformed -D option: " + arg);
                    throw new RuntimeException();
                }
            }
            if (arg.startsWith("-cp:")) {
                this.classPath = ArgsUtilities.toPlatformPath((String)arg.substring("-cp:".length()), (boolean)true);
                continue;
            }
            if (arg.startsWith("-java5cp:")) {
                this.java5ClassPath = ArgsUtilities.toPlatformPath((String)arg.substring("-java5cp:".length()), (boolean)true);
                continue;
            }
            if (arg.startsWith("-exclude:")) {
                excludeFile = arg.substring("-exclude:".length());
                continue;
            }
            if (arg.startsWith("-noclassdeffounderrorclass:")) {
                this.noClassDefFoundErrorClasses.add(arg.substring("-noclassdeffounderrorclass:".length()));
                continue;
            }
            if (arg.startsWith("-o:")) {
                this.suiteName = arg.substring("-o:".length());
                continue;
            }
            if (arg.equals("-jars")) {
                this.createJars = true;
                continue;
            }
            if (arg.equals("-metadata")) {
                this.createMetadata = true;
                continue;
            }
            if (arg.equals("-nometadata")) {
                this.createMetadata = false;
                continue;
            }
            if (arg.startsWith("-endian:")) {
                String value = arg.substring("-endian:".length());
                if (value.equals("big")) {
                    VM.setIsBigEndian(true);
                    continue;
                }
                if (value.equals("little")) {
                    VM.setIsBigEndian(false);
                    continue;
                }
                this.usage("invalid endianess: " + value);
                throw new RuntimeException();
            }
            if (arg.startsWith("-arch:")) {
                String arch = arg.substring("-arch:".length()).toUpperCase();
                Romizer.putBuildProperty("ARCHITECTURE", arch);
                continue;
            }
            if (arg.startsWith("-strip:") || arg.startsWith("-prune:")) {
                char type = arg.substring("-strip:".length()).charAt(0);
                if (type == 'a') {
                    this.suiteType = 0;
                    continue;
                }
                if (type == 'd') {
                    this.suiteType = 3;
                    continue;
                }
                if (type == 'l') {
                    this.suiteType = 1;
                    continue;
                }
                if (type == 'e') {
                    this.suiteType = 2;
                    continue;
                }
                this.usage("invalid suite type: " + type);
                throw new RuntimeException();
            }
            if (arg.equals("-lnt")) {
                MethodMetadata.preserveLineNumberTables();
                continue;
            }
            if (arg.equals("-lvt")) {
                MethodMetadata.preserveLocalVariableTables();
                continue;
            }
            if (arg.equals("-timer")) {
                timer = true;
                continue;
            }
            if (arg.equals("-stats")) {
                System.setProperty("translator.stats", "true");
                stats = true;
                continue;
            }
            if (arg.startsWith("-trace")) {
                if (arg.startsWith("-tracefilter:")) {
                    String optArg = arg.substring("-tracefilter:".length());
                    Tracer.setFilter((String)optArg);
                    continue;
                }
                Tracer.enableFeature((String)arg.substring("-trace".length()));
                if (!arg.equals("-traceconverting")) continue;
                Tracer.enableFeature((String)"loading");
                continue;
            }
            if (arg.equals("-verbose") | arg.equals("-v")) {
                System.setProperty("translator.verbose", "true");
                VM.setVerbose(true);
                continue;
            }
            if (arg.startsWith("-h")) {
                this.usage(null);
                return null;
            }
            if (arg.startsWith("-boot:")) {
                String bootSuiteName = arg.substring("-boot:".length());
                suiteUrl = "file://" + bootSuiteName + ".suite";
                System.setProperty("bootstrap.suite.url", suiteUrl);
                try {
                    parentSuite = this.objectGraphLoader.loadSuite(suiteUrl);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                System.setProperty("bootstrap.suite.url", suiteUrl);
                continue;
            }
            if (arg.startsWith("-parent:")) {
                String parentSuiteName = arg.substring("-parent:".length());
                suiteUrl = "file://" + parentSuiteName + ".suite";
                try {
                    parentSuite = this.objectGraphLoader.loadSuite(suiteUrl);
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (arg.startsWith("-suitepath:")) {
                String path = arg.substring("-suitepath:".length());
                ObjectMemoryLoader.addFilePath((String)path);
                continue;
            }
            if (arg.startsWith("-nobuildproperties")) {
                if (buildDotOverrideFileName != null) {
                    throw new RuntimeException("Can't specify both -nobuildproperties and -override:");
                }
                buildProperties = new Properties();
                continue;
            }
            if (arg.startsWith("-override:")) {
                if (buildProperties != null) {
                    throw new RuntimeException("Can't specify both -nobuildproperties and -override:");
                }
                buildDotOverrideFileName = arg.substring("-override:".length());
                continue;
            }
            if (arg.startsWith("-key:")) {
                key = arg.substring("-key:".length());
                continue;
            }
            if (arg.startsWith("-value:")) {
                if (key == null) {
                    throw new RuntimeException("Did not specify a key for " + arg);
                }
                String value = arg.substring("-key:".length());
                this.jadProperties.put(key, value);
                continue;
            }
            if (this.protoTranslator.processOption(arg)) continue;
            this.usage("Unknown option " + arg);
            throw new RuntimeException("Unknown option " + arg);
        }
        if (this.suiteName == null) {
            this.usage("missing -o option");
            throw new RuntimeException();
        }
        if (this.classPath == null) {
            this.usage("missing -cp option");
            throw new RuntimeException();
        }
        if ((this.suiteType == 1 || this.suiteType == 2) && (file = new File(this.suiteName + "." + (this.suiteType == 1 ? "library" : "extendable.library") + ".properties")).exists()) {
            VM.resetSymbolsStripping(file);
        }
        while (argc != args.length && !(classArg = args[argc++]).equals("--")) {
            ArgsUtilities.processClassArg((String)ArgsUtilities.toPlatformPath((String)classArg, (boolean)false), classNames, resources);
        }
        if (!classNames.isEmpty()) {
            if (excludeFile == null && new File(this.suiteName + ".exclude").exists()) {
                excludeFile = this.suiteName + ".exclude";
            }
            if (excludeFile != null) {
                this.excludeClasses(classNames, excludeFile);
            }
            this.suite = new Suite(new File(this.suiteName).getName(), parentSuite);
            for (String className : this.noClassDefFoundErrorClasses) {
                if (!this.suite.shouldThrowNoClassDefFoundErrorFor(className)) continue;
                this.noClassDefFoundErrorClasses.remove(className);
            }
        } else {
            this.usage("missing class names for suite " + this.suiteName);
            throw new RuntimeException();
        }
        this.suite.addNoClassDefFoundErrorClassNames(this.noClassDefFoundErrorClasses.toArray(new String[this.noClassDefFoundErrorClasses.size()]));
        if (argc != args.length) {
            String[] newArgs = new String[args.length - argc];
            System.arraycopy(args, argc, newArgs, 0, newArgs.length);
            return newArgs;
        }
        return null;
    }

    private void excludeClasses(Vector<String> classNames, String excludeFile) {
        this.excludes = Romizer.readExcludesFile(excludeFile);
        Vector<String> filteredClassNames = new Vector<String>(classNames.size());
        boolean firstLoop = true;
        for (String className : classNames) {
            boolean include = true;
            for (String spec : this.excludes) {
                boolean isPrefix;
                if (firstLoop && VM.isVerbose()) {
                    System.out.println("excluding: " + spec);
                }
                if (isPrefix = spec.endsWith("*")) {
                    spec = spec.substring(0, spec.length() - 1);
                }
                if (!(isPrefix ? className.startsWith(spec) : className.equals(spec))) continue;
                include = false;
                break;
            }
            if (include) {
                filteredClassNames.addElement(className);
            }
            firstLoop = false;
        }
        classNames.removeAllElements();
        classNames.addAll(filteredClassNames);
    }

    private void translate(Vector<String> classNames) {
        if (classNames.isEmpty()) {
            throw new RuntimeException("No classes found for " + this.suite);
        }
        System.out.println("[translating " + this.suite + " ...]");
        VM.setCurrentIsolate(null);
        Isolate isolate = new Isolate(null, null, this.suite);
        VM.setCurrentIsolate(isolate);
        isolate.setTranslator((TranslatorInterface)new Translator());
        TranslatorInterface translator = isolate.getTranslator();
        try {
            translator.open(this.suite, this.classPath);
            this.suite.addNoClassDefFoundErrorClassNames(this.noClassDefFoundErrorClasses.toArray(new String[this.noClassDefFoundErrorClasses.size()]));
            Object[] sortedClassNames = new String[classNames.size()];
            classNames.copyInto(sortedClassNames);
            Arrays.sort(sortedClassNames, new Comparator<String>(){

                @Override
                public int compare(String object1, String object2) {
                    if (object1 == object2) {
                        return 0;
                    }
                    return object1.compareTo(object2);
                }
            });
            for (Object className : sortedClassNames) {
                if (this.noClassDefFoundErrorClasses.indexOf(className) != -1) continue;
                Klass.getClass((String)className, (boolean)false);
            }
            translator.close(this.suiteType);
        }
        catch (VerifyError t) {
            System.err.println((Object)t);
            this.lastClassName = translator.getLastClassName();
            throw t;
        }
        catch (NoClassDefFoundError t) {
            this.lastClassName = translator.getLastClassName();
            throw t;
        }
    }

    private void verifyExclusions(Suite suite) {
        if (this.excludes != null) {
            for (int i = 0; i != suite.getClassCount(); ++i) {
                Klass klass = suite.getKlass(i);
                if (klass == null) continue;
                String className = klass.getInternalName();
                for (String spec : this.excludes) {
                    if (!(spec.endsWith("*") ? className.startsWith(spec.substring(0, spec.length() - 1)) : className.equals(spec))) continue;
                    System.err.println("**WARNING**: suite includes class '" + className + "' that is matched by exclusion spec '" + spec + "'");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createImage() throws IOException {
        File file = new File(this.suiteName + ".sym");
        PrintStream symbols = VM.Streams[2] = new PrintStream(new FileOutputStream(file));
        this.generatedFiles.addElement(file.getAbsolutePath());
        GC.setAllocationEnabled((boolean)true);
        Suite strippedSuite = this.suite.strip(this.suiteType, this.suite.getName(), this.suite.getParent());
        strippedSuite.close();
        this.verifyExclusions(strippedSuite);
        String suiteFileName = this.suiteName + ".suite";
        String url = "file://" + suiteFileName;
        DataOutputStream dos = Connector.openDataOutputStream((String)url);
        int memoryStart = NativeUnsafe.getMemorySize();
        String uri = strippedSuite.getParent() == null ? "memory:bootstrap" : url;
        strippedSuite.save(dos, uri, VM.isBigEndian());
        this.generatedFiles.addElement(new File(suiteFileName).getAbsolutePath());
        if (this.createMetadata) {
            ObjectMemory objectMemory;
            String metadataUrl = "file://" + suiteFileName + ".metadata";
            DataOutputStream metadataDos = Connector.openDataOutputStream((String)metadataUrl);
            Suite metadataSuite = this.suite.strip(4, strippedSuite.getName() + ".suite" + ".metadata", strippedSuite);
            int memorySizePrior = NativeUnsafe.getMemorySize();
            ObjectGraphSerializer.pushObjectMap();
            try {
                objectMemory = metadataSuite.save(metadataDos, metadataUrl, VM.isBigEndian());
            }
            finally {
                ObjectGraphSerializer.popObjectMap();
            }
            GC.unRegisterReadOnlyObjectMemory((ObjectMemory)objectMemory);
            NativeUnsafe.setMemorySize((int)memorySizePrior);
            GC.setAllocTop((Address)Address.zero().add(memorySizePrior));
            this.generatedFiles.addElement(new File(suiteFileName + ".metadata").getAbsolutePath());
        }
        if (this.createJars) {
            String jarFilePath = this.suiteName + "_classes.jar";
            File jarFile = new File(jarFilePath);
            this.jarClasses(jarFile, strippedSuite, false);
            this.generatedFiles.addElement(jarFile.getAbsolutePath());
            if (this.java5ClassPath != null) {
                jarFilePath = this.suiteName + "_java5.jar";
                jarFile = new File(jarFilePath);
                this.jarClasses(jarFile, strippedSuite, true);
                this.generatedFiles.addElement(jarFile.getAbsolutePath());
            }
        }
        NativeUnsafe.setMemorySize((int)memoryStart);
        ObjectMemory memory = ObjectMemoryLoader.load((DataInputStream)Connector.openDataInputStream((String)url), (String)url, (boolean)false).objectMemory;
        VM.printNatives(symbols);
        symbols.println("PMR.ROM_SIZE=" + memory.getSize());
        symbols.println("PMR.ROM_SUITE_TABLE=" + memory.getRoot());
        symbols.println("PMR.REVERSE_PARAMETERS=1");
        this.printGlobalVariables(symbols);
        this.printGlobalAddresses(symbols);
        this.printGlobalOops(symbols);
        symbols.close();
    }

    private void printGlobalAddresses(PrintStream symbols) {
        Hashtable globalAddrs = InstructionEmitter.getGlobalAddrVariables();
        symbols.println("ROM.GLOBAL.ADDR.COUNT=" + globalAddrs.size());
        for (Map.Entry entry : globalAddrs.entrySet()) {
            symbols.println("ROM.GLOBAL.ADDR." + entry.getValue() + "=" + (String)entry.getKey());
        }
    }

    private void printGlobalOops(PrintStream symbols) {
        Hashtable globalOops = InstructionEmitter.getGlobalOopVariables();
        symbols.println("ROM.GLOBAL.OOP.COUNT=" + globalOops.size());
        for (Map.Entry entry : globalOops.entrySet()) {
            symbols.println("ROM.GLOBAL.OOP." + entry.getValue() + "=" + (String)entry.getKey());
        }
    }

    private void printGlobalVariables(PrintStream symbols) {
        Hashtable globalInts = InstructionEmitter.getGlobalIntVariables();
        symbols.println("ROM.GLOBAL.INT.COUNT=" + globalInts.size());
        for (Map.Entry entry : globalInts.entrySet()) {
            symbols.println("ROM.GLOBAL.INT." + entry.getValue() + "=" + (String)entry.getKey());
        }
    }

    protected String getLastClassName() {
        return this.lastClassName;
    }

    private void jarClasses(File file, Suite suite, boolean doJava5) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            JarOutputStream zos = new JarOutputStream(fos);
            ClasspathConnection classPath = (ClasspathConnection)Connector.open((String)("classpath://" + (doJava5 ? this.java5ClassPath : this.classPath)));
            for (int i = 0; i < suite.getClassCount(); ++i) {
                Klass klass = suite.getKlass(i);
                if (klass == null || klass.isSynthetic()) continue;
                String classFilePath = klass.getName().replace('.', '/') + ".class";
                this.addFileToJar(zos, classPath, classFilePath);
            }
            zos.close();
        }
        catch (IOException e) {
            throw new RuntimeException("IO error creating jar file", e);
        }
    }

    private void addFileToJar(ZipOutputStream zos, ClasspathConnection classPath, String filePath) throws IOException {
        byte[] data = classPath.getBytes(filePath);
        ZipEntry e = new ZipEntry(filePath);
        e.setTime(System.currentTimeMillis());
        zos.putNextEntry(e);
        zos.write(data);
        zos.closeEntry();
    }

    private void createCHeader() throws IOException {
        File headerFile = new File("vmcore/src/vm/rom.h");
        Properties symbols = new Properties();
        symbols.load(new FileInputStream(this.suiteName + ".sym"));
        if (CHeaderFileCreator.update(this.suite, headerFile, symbols)) {
            this.generatedFiles.addElement(headerFile.getAbsolutePath());
        } else {
            System.out.println(headerFile.getAbsolutePath() + " is already up to date");
        }
    }

    private void createSuiteAPI() throws IOException {
        Suite apiSuite = this.suite.strip(this.suiteType, this.suite.getName(), this.suite.getParent());
        File api = new File(this.suiteName + ".suite" + ".api");
        PrintStream out = new PrintStream(new FileOutputStream(api));
        Romizer.printAPI(out, apiSuite);
        this.generatedFiles.addElement(api.getAbsolutePath());
        out.close();
    }

    public static void printAPI(PrintStream out, Suite suite) {
        out.println(".suite " + suite.getName());
        for (int i = 0; i != suite.getClassCount(); ++i) {
            KlassMetadata metadata;
            Klass klass = suite.getKlass(i);
            if (klass == null || klass.isSynthetic() || klass.isSourceSynthetic() || klass == Klass.STRING_OF_BYTES || Romizer.isAnonymousOrPrivate(klass.getName()) || (metadata = suite.getMetadata(klass)) == null) continue;
            out.println(".class " + klass.getName());
            Romizer.printFieldsAPI(out, metadata, 1);
            Romizer.printFieldsAPI(out, metadata, 0);
            Romizer.printMethodsAPI(out, metadata, 3);
            Romizer.printMethodsAPI(out, metadata, 2);
        }
    }

    private static boolean isAnonymousOrPrivate(String className) {
        int index = className.lastIndexOf(36);
        if (index == -1) {
            return false;
        }
        if (className.length() > index + 1) {
            char c = className.charAt(index + 1);
            return c >= '0' && c <= '9';
        }
        return false;
    }

    private static void printFieldsAPI(PrintStream out, KlassMetadata klass, int category) {
        SymbolParser symbols = klass.getSymbolParser();
        int count = symbols.getMemberCount(category);
        for (int i = 0; i != count; ++i) {
            int id = symbols.getMemberID(category, i);
            Field field = new Field(klass, id);
            if (field.isSourceSynthetic()) continue;
            out.println("    .field " + field.getName() + ' ' + field.getType().getSignature());
        }
    }

    private static void printMethodsAPI(PrintStream out, KlassMetadata klass, int category) {
        SymbolParser symbols = klass.getSymbolParser();
        int count = symbols.getMemberCount(category);
        for (int i = 0; i != count; ++i) {
            int id = symbols.getMemberID(category, i);
            Method method = new Method(klass, id);
            if (method.isNative() && !VM.isLinkableNativeMethod(method.getFullyQualifiedName()) || method.isInterpreterInvoked() || method.isSourceSynthetic() || method.isClassInitializer()) continue;
            out.print("    .method " + method.getName() + " (");
            Klass[] types = method.getParameterTypes();
            for (int j = 0; j != types.length; ++j) {
                Klass type = types[j];
                out.print(type.getSignature());
            }
            out.println(")" + (method.isConstructor() ? "V" : method.getReturnType().getSignature()));
        }
    }

    static {
        stats = false;
    }
}

