/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk;

import com.sun.squawk.Address;
import com.sun.squawk.Isolate;
import com.sun.squawk.Klass;
import com.sun.squawk.Member;
import com.sun.squawk.Method;
import com.sun.squawk.ObjectGraphSerializer;
import com.sun.squawk.ObjectMemorySerializer;
import com.sun.squawk.Offset;
import com.sun.squawk.Romizer;
import com.sun.squawk.Suite;
import com.sun.squawk.UWord;
import com.sun.squawk.util.Assert;
import com.sun.squawk.vm.Native;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class VM {
    private static Isolate currentIsolate;
    static boolean extendsEnabled;
    private static boolean bigEndian;
    private static int nextIsolateID;
    protected static boolean isVerbose;
    static List<Matcher> stripMatchers;
    public static final int STREAM_STDOUT = 0;
    public static final int STREAM_STDERR = 1;
    static final int STREAM_SYMBOLS = 2;
    static final int STREAM_HEAPTRACE = 3;
    static int stream;
    static final PrintStream[] Streams;
    private static Hashtable<String, Integer> methodTable;
    private static Hashtable<String, String> unused;

    public static char getPathSeparatorChar() {
        return File.pathSeparatorChar;
    }

    static int allocateIsolateID() {
        return nextIsolateID++;
    }

    public static char getFileSeparatorChar() {
        return File.separatorChar;
    }

    public static boolean isVerbose() {
        return isVerbose;
    }

    public static void setVerbose(boolean verbose) {
        isVerbose = verbose;
    }

    public static boolean isVeryVerbose() {
        return false;
    }

    public static boolean isHosted() {
        return true;
    }

    public static void setProperty(String name, String value) {
        System.setProperty(name, value);
    }

    public static boolean isBigEndian() {
        return bigEndian;
    }

    public static void setIsBigEndian(boolean value) {
        bigEndian = value;
    }

    public static void assume(boolean b) {
        Assert.that((boolean)b);
    }

    public static Isolate getCurrentIsolate() {
        return currentIsolate;
    }

    static void registerIsolate(Isolate isolate) {
    }

    static void setCurrentIsolate(Isolate isolate) {
        currentIsolate = isolate;
    }

    static void resetSymbolsStripping(File path) {
        stripMatchers.clear();
        boolean enableDynamicClassloading = Boolean.parseBoolean(Romizer.getBuildProperty("ENABLE_DYNAMIC_CLASSLOADING"));
        try {
            FileInputStream fis = new FileInputStream(path);
            Properties properties = new Properties();
            properties.load(fis);
            fis.close();
            System.out.println("Loaded suite stripping settings from " + path);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                int action;
                String k = (String)entry.getKey();
                String v = (String)entry.getValue();
                boolean scopeAll = true;
                if ("keep".equalsIgnoreCase(v)) {
                    action = 0;
                } else if ("keepclass".equalsIgnoreCase(v)) {
                    action = 0;
                    scopeAll = false;
                } else if ("strip".equalsIgnoreCase(v)) {
                    action = 1;
                } else if ("internal".equalsIgnoreCase(v)) {
                    action = enableDynamicClassloading ? 2 : 1;
                } else {
                    throw new IllegalArgumentException("value for property " + k + " in " + path + " must be 'keep', 'strip', or 'internal'");
                }
                if (k.endsWith("*")) {
                    stripMatchers.add(new PackageMatcher(k, action));
                    continue;
                }
                if (k.indexOf(35) != -1) {
                    stripMatchers.add(new MemberMatcher(k, action));
                    continue;
                }
                if (scopeAll) {
                    stripMatchers.add(new ClassMatcher(k, action));
                    continue;
                }
                stripMatchers.add(new ClassOnlyMatcher(k, action));
            }
        }
        catch (IOException e) {
            System.err.println("Error loading properties from " + path + ": " + e);
            stripMatchers.clear();
        }
    }

    private static Matcher getMatcher(String s) {
        Matcher current = null;
        for (Matcher m : stripMatchers) {
            if (!m.matches(s) || current != null && !m.moreSpecificThan(current)) continue;
            current = m;
        }
        return current;
    }

    private static boolean strip(String s) {
        Matcher current = VM.getMatcher(s);
        return current != null && current.action != 0;
    }

    public static boolean stripSymbols(Klass klass) {
        boolean result = VM.strip(klass.getName());
        if (result & !VM.isInternal(klass)) {
            klass.updateModifiers(0x4000000);
        }
        return result;
    }

    private static String getSymbolString(Member member) {
        String s = member.getDefiningClass().getName() + "#" + member.getName();
        if (member instanceof Method) {
            Method method = (Method)member;
            Klass[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length == 0) {
                s = s + "()";
            } else {
                StringBuffer buf = new StringBuffer(15);
                buf.append('(');
                for (int i = 0; i < parameterTypes.length; ++i) {
                    buf.append(parameterTypes[i].getInternalName());
                    if (i == parameterTypes.length - 1) continue;
                    buf.append(',');
                }
                buf.append(')');
                s = s + buf.toString();
            }
        }
        return s;
    }

    public static boolean stripSymbols(Member member) {
        return VM.strip(VM.getSymbolString(member));
    }

    public static boolean isInternal(Member member) {
        String s = VM.getSymbolString(member);
        Matcher current = VM.getMatcher(s);
        return current != null && current.action == 2;
    }

    public static boolean isInternal(Klass klass) {
        Matcher current = VM.getMatcher(klass.getName());
        return current != null && current.action == 2;
    }

    public static Object getClass(Object object) {
        return object.getClass();
    }

    public static boolean isArray(Object object) {
        return object.getClass().isArray();
    }

    static void zeroWords(Address start, Address end) {
    }

    public static boolean usingTypeMap() {
        return false;
    }

    public static int setStream(int stream) {
        Assert.always((stream >= 0 && stream <= 3 ? 1 : 0) != 0, (String)"invalid stream specifier");
        int old = VM.stream;
        VM.stream = stream;
        return old;
    }

    public static void println(String msg) {
        PrintStream out = Streams[stream];
        out.println(msg);
        out.flush();
    }

    public static void println(boolean x) {
        PrintStream out = Streams[stream];
        out.println(x);
        out.flush();
    }

    public static void println() {
        PrintStream out = Streams[stream];
        out.println();
        out.flush();
    }

    public static void print(String s) {
        PrintStream out = Streams[stream];
        out.print(s);
        out.flush();
    }

    public static void print(int i) {
        PrintStream out = Streams[stream];
        out.print(i);
        out.flush();
    }

    public static void print(char ch) {
        PrintStream out = Streams[stream];
        out.print(ch);
        out.flush();
    }

    static void printAddress(Address val) {
        VM.printUWord(val.toUWord());
    }

    public static void printAddress(Object val) {
        PrintStream out = Streams[stream];
        out.print(val);
        out.flush();
    }

    public static void printUWord(UWord val) {
        PrintStream out = Streams[stream];
        out.print(val);
        out.flush();
    }

    public static void printOffset(Offset val) {
        PrintStream out = Streams[stream];
        out.print(val);
        out.flush();
    }

    public static void fatalVMError() {
        throw new Error();
    }

    static ObjectMemorySerializer.ControlBlock copyObjectGraph(Object object) {
        VM.assume(object instanceof Suite);
        return ObjectGraphSerializer.serialize(object);
    }

    static void copyBytes(Object src, int srcPos, Object dst, int dstPos, int length, boolean nvmDst) {
    }

    public static void arraycopyPrimitive0(Object src, int src_position, Object dst, int dst_position, int totalLength, int dataSize) {
        System.arraycopy(src, src_position, dst, dst_position, totalLength);
    }

    public static void arraycopyObject0(Object src, int src_position, Object dst, int dst_position, int length) {
        System.arraycopy(src, src_position, dst, dst_position, length);
    }

    static boolean isLinkableNativeMethod(String name) {
        String table = "0com.sun.squawk.Address.add JOffset Hnd Gdiff Geq GfromObject KPrimitive Ghi Ieq GisMax IZero Glo Ieq Gmax Gne Gor GroundDown PToWord LUp NToWord Gsub JOffset GtoObject IUWord Gzero ?UWord.and Eeq EfromPrimitive Ehi Geq EisMax GZero Elo Geq Emax Ene Eor EtoInt GOffset GPrimitive Ezero ?Offset.add FbytesToWords Feq FfromPrimitive Fge Gt FisZero Fle Gt Fne Fsub FtoInt HPrimitive HUWord FwordsToBytes Fzero ";
        String last = null;
        int id = 0;
        int start = 0;
        int end = table.indexOf(32);
        while (end != -1) {
            int sharedSubstringLength = table.charAt(start++) - 48;
            String entryName = table.substring(start, end);
            if (sharedSubstringLength != 0) {
                Assert.that((last != null ? 1 : 0) != 0);
                entryName = last.substring(0, sharedSubstringLength) + entryName;
            }
            if (entryName.equals(name)) {
                return true;
            }
            start = end + 1;
            end = table.indexOf(32, start);
            last = entryName;
            ++id;
        }
        return false;
    }

    public static int lookupNative(String name) {
        Integer id = methodTable.get(name);
        if (id != null) {
            unused.remove(name);
            return id;
        }
        return -1;
    }

    public static void printNatives(PrintStream out) {
        for (Map.Entry<String, Integer> entry : methodTable.entrySet()) {
            out.println("NATIVE." + entry.getKey() + ".NAME=" + entry.getValue());
        }
    }

    private VM() {
    }

    static {
        stripMatchers = new ArrayList<Matcher>();
        stream = 0;
        Streams = new PrintStream[4];
        methodTable = new Hashtable();
        unused = new Hashtable();
        VM.Streams[0] = System.out;
        VM.Streams[1] = System.err;
        try {
            Class<Native> clazz = Native.class;
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (field.getType() != Integer.TYPE) continue;
                String name = field.getName().replace('_', '.').replace('$', '.');
                int number = field.getInt(null);
                methodTable.put(name, new Integer(number));
                unused.put(name, name);
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    static class MemberMatcher
    extends Matcher {
        private final String pattern;

        MemberMatcher(String pattern, int action) {
            super(action, 2);
            if (pattern.indexOf(42) != -1) {
                throw new IllegalArgumentException("Member name must not contain '*'");
            }
            this.pattern = pattern;
        }

        @Override
        boolean moreSpecificThan(Matcher m) {
            if (m instanceof MemberMatcher) {
                return this.pattern.length() >= ((MemberMatcher)m).pattern.length();
            }
            return this.precedence > m.precedence;
        }

        @Override
        public boolean matches(String s) {
            if (s.indexOf(35) == -1) {
                return false;
            }
            return s.startsWith(this.pattern);
        }

        public String toString() {
            return "MemberMatcher [" + this.pattern + ']';
        }
    }

    static class ClassOnlyMatcher
    extends ClassMatcher {
        ClassOnlyMatcher(String pattern, int action) {
            super(pattern, action);
        }

        @Override
        public boolean matches(String s) {
            return this.pattern.equals(s);
        }

        @Override
        public String toString() {
            return "ClassOnlyMatcher [" + this.pattern + ": " + this.action + ']';
        }
    }

    static class ClassMatcher
    extends Matcher {
        protected final String pattern;

        ClassMatcher(String pattern, int action) {
            super(action, 1);
            if (pattern.indexOf(35) != -1 || pattern.indexOf(42) != -1) {
                throw new IllegalArgumentException("Class name must not contain '*' or '#'");
            }
            this.pattern = pattern;
        }

        @Override
        boolean moreSpecificThan(Matcher m) {
            if (m instanceof ClassMatcher) {
                return true;
            }
            return this.precedence > m.precedence;
        }

        @Override
        public boolean matches(String s) {
            int index = s.indexOf(35);
            if (index != -1) {
                s = s.substring(0, index);
            }
            return this.pattern.equals(s);
        }

        public String toString() {
            return "ClassMatcher [" + this.pattern + ']';
        }
    }

    static class PackageMatcher
    extends Matcher {
        private final String pkg;
        private final boolean recursive;

        PackageMatcher(String pattern, int action) {
            super(action, 0);
            if (pattern.endsWith(".**")) {
                this.pkg = pattern.substring(0, pattern.length() - 3);
                this.recursive = true;
            } else {
                if (!pattern.endsWith(".*")) {
                    throw new IllegalArgumentException("Package pattern must end with \".*\" or \".**\"");
                }
                this.pkg = pattern.substring(0, pattern.length() - 2);
                this.recursive = false;
            }
        }

        @Override
        boolean moreSpecificThan(Matcher m) {
            if (m instanceof PackageMatcher) {
                if (!this.recursive) {
                    return true;
                }
                PackageMatcher pm = (PackageMatcher)m;
                if (!pm.recursive) {
                    return false;
                }
                return this.pkg.length() >= pm.pkg.length();
            }
            return this.precedence > m.precedence;
        }

        @Override
        boolean matches(String s) {
            if (this.recursive) {
                return s.startsWith(this.pkg);
            }
            if (!s.startsWith(this.pkg)) {
                return false;
            }
            return (s = s.substring(this.pkg.length())).indexOf(46) == -1;
        }

        public String toString() {
            return "PackageMatcher [" + this.pkg + (this.recursive ? ".*" : "") + ']';
        }
    }

    static abstract class Matcher {
        public static final int PRECEDENCE_PACKAGE = 0;
        public static final int PRECEDENCE_CLASS = 1;
        public static final int PRECEDENCE_MEMBER = 2;
        public static final int KEEP = 0;
        public static final int STRIP = 1;
        public static final int INTERNAL = 2;
        final int action;
        final int precedence;

        Matcher(int action, int precedence) {
            this.action = action;
            this.precedence = precedence;
        }

        abstract boolean matches(String var1);

        abstract boolean moreSpecificThan(Matcher var1);
    }
}

