/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.romizer;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;

public class EmbeddedSquawkClassLoader
extends ClassLoader {
    public static void runMain(String className, String ... args) {
        EmbeddedSquawkClassLoader loader = new EmbeddedSquawkClassLoader();
        try {
            Class<?> mainClass = loader.loadClass(className);
            Method mainMethod = mainClass.getMethod("main", String[].class);
            mainMethod.invoke(null, new Object[]{args});
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Can't find class " + className + " in current class path", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            if (name.startsWith("java.")) {
                return super.loadClass(name, resolve);
            }
            if (name.startsWith("sun.")) {
                return super.loadClass(name, resolve);
            }
            URL classResource = this.getResource(name.replace('.', '/') + ".class");
            if (classResource == null) {
                return super.loadClass(name, resolve);
            }
            try {
                int read;
                InputStream classInput = classResource.openStream();
                byte[] buffer = new byte[classInput.available()];
                for (int offset = 0; offset < buffer.length; offset += read) {
                    read = classInput.read(buffer, offset, buffer.length - offset);
                }
                if (classInput.available() != 0) {
                    throw new RuntimeException("Have not implemented this case yet");
                }
                c = this.defineClass(name, buffer, 0, buffer.length);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }
}

