/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.io.j2se.socket;

import com.sun.squawk.io.ConnectionBase;
import com.sun.squawk.io.j2se.ParameterParser;
import com.sun.squawk.io.j2se.UniversalFilterInputStream;
import com.sun.squawk.io.j2se.UniversalFilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import javax.microedition.io.Connection;
import javax.microedition.io.StreamConnection;

public class Protocol
extends ConnectionBase
implements StreamConnection {
    Socket socket;
    int opens = 0;
    Parameters parameters = new Parameters();

    public void open(String name, int mode, boolean timeouts) throws IOException {
        throw new RuntimeException("Should not be called");
    }

    @Override
    public Connection open(String protocol, String originalName, int mode, boolean timeouts) throws IOException {
        if (originalName.charAt(0) != '/' || originalName.charAt(1) != '/') {
            throw new IllegalArgumentException("Protocol must start with \"//\" " + originalName);
        }
        String name = originalName.substring(2);
        try {
            int colon = name.indexOf(58);
            if (colon == -1) {
                throw new IllegalArgumentException("Bad protocol specification in " + name);
            }
            String nameOrIP = name.substring(0, colon);
            if (nameOrIP.length() == 0) {
                com.sun.squawk.io.j2se.serversocket.Protocol con = new com.sun.squawk.io.j2se.serversocket.Protocol();
                con.open("socket", originalName, mode, timeouts);
                return con;
            }
            int port = Integer.parseInt(name.substring(colon + 1));
            this.parameters.parse(name.substring(2));
            this.socket = new Socket(nameOrIP, port);
            this.socket.setSoTimeout(this.parameters.timeout);
            ++this.opens;
            return this;
        }
        catch (NumberFormatException x) {
            throw new IllegalArgumentException("Invalid port number in " + name);
        }
    }

    public void open(Socket socket, Parameters parameters) throws IOException {
        this.socket = socket;
        this.parameters = parameters;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        UniversalFilterInputStream is = this.parameters.inLog != null ? new UniversalFilterInputStream(this, this.socket.getInputStream(), this.parameters.inLog) : new UniversalFilterInputStream(this, this.socket.getInputStream());
        ++this.opens;
        return is;
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        UniversalFilterOutputStream os = this.parameters.outLog != null ? new UniversalFilterOutputStream(this, this.socket.getOutputStream(), this.parameters.outLog) : new UniversalFilterOutputStream(this, this.socket.getOutputStream());
        ++this.opens;
        return os;
    }

    @Override
    public void close() throws IOException {
        if (--this.opens == 0) {
            this.socket.close();
        }
    }

    public static class Parameters
    extends ParameterParser {
        public String inLog;
        public String outLog;
        public int timeout;
        public int acceptTimeout;

        @Override
        public boolean parameter(String key, String value) throws IllegalArgumentException {
            if (key.equals("inputLog")) {
                this.inLog = value;
            } else if (key.equals("outputLog")) {
                this.outLog = value;
            } else if (key.equals("acceptTimeout")) {
                try {
                    this.acceptTimeout = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("acceptTimeout value is not a well-formed integer: " + value);
                }
            } else if (key.equals("timeout")) {
                try {
                    this.timeout = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("timeout value is not a well-formed integer: " + value);
                }
            } else {
                return false;
            }
            return true;
        }
    }
}

