/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.io.j2se.systemproperties;

import com.sun.squawk.io.ConnectionBase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.TreeMap;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.InputConnection;

public class Protocol
extends ConnectionBase
implements InputConnection {
    @Override
    public Connection open(String protocol, String name, int mode, boolean timeouts) throws IOException {
        if (!name.equals("")) {
            throw new IllegalArgumentException("Bad protocol option:" + name);
        }
        return this;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        TreeMap<Object, Object> properties = new TreeMap<Object, Object>(System.getProperties());
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            if (!localhost.isLoopbackAddress()) {
                properties.put("net.localhost.address", localhost.getHostAddress());
                properties.put("net.localhost.name", localhost.getHostName());
            }
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        for (Map.Entry entry : properties.entrySet()) {
            dos.writeUTF((String)entry.getKey());
            dos.writeUTF((String)entry.getValue());
        }
        baos.close();
        return new DataInputStream(new ByteArrayInputStream(baos.toByteArray()));
    }

    public static void main(String[] args) throws IOException {
        DataInputStream propertiesStream = Connector.openDataInputStream("systemproperties:");
        TreeMap<String, String> properties = new TreeMap<String, String>();
        while (propertiesStream.available() != 0) {
            properties.put(propertiesStream.readUTF(), propertiesStream.readUTF());
        }
        for (Map.Entry e : properties.entrySet()) {
            System.out.println(e.getKey() + "=" + e.getValue());
        }
    }
}

