/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

public class HexDump {
    private int columns = 16;
    private boolean binary;
    private int radix = 16;
    private final InputStream in;
    private final PrintStream out;

    public HexDump(String[] args) throws IOException {
        String arg;
        int argc;
        for (argc = 0; argc != args.length && (arg = args[argc]).charAt(0) == '-'; ++argc) {
            if (arg.equals("-c")) {
                this.columns = Integer.parseInt(this.getOptArg(args, ++argc, "-c"));
                continue;
            }
            if (arg.equals("-radix")) {
                this.radix = Integer.parseInt(this.getOptArg(args, ++argc, "-radix"));
                continue;
            }
            if (arg.equals("-b") || arg.equals("-bits")) {
                this.binary = true;
                continue;
            }
            if (arg.equals("-h")) {
                this.usage(null);
                System.exit(0);
                continue;
            }
            this.usage("Unknown option: " + arg);
            System.exit(1);
        }
        if (argc < args.length) {
            this.in = new BufferedInputStream(new FileInputStream(args[argc++]));
            this.out = argc < args.length ? new PrintStream(new BufferedOutputStream(new FileOutputStream(args[argc]))) : System.out;
        } else {
            this.in = new BufferedInputStream(System.in);
            this.out = System.out;
        }
    }

    private String getOptArg(String[] args, int index, String opt) {
        if (index >= args.length) {
            this.usage("The " + opt + " option requires an argument.");
            throw new RuntimeException();
        }
        return args[index];
    }

    private void usage(String errMsg) {
        PrintStream out = System.out;
        if (errMsg != null) {
            out.println(errMsg);
        }
        Integer.toString(4, 4);
        out.println("Usage: HexDump [-options] [infile [outfile]]");
        out.println("where options include:");
        out.println();
        out.println("    -c cols        format <cols> octets per line (default=16)");
        out.println("    -b             binary digit dump");
        out.println("    -radix n       format offsets with radix <n> (default=16)");
        out.println("    -h             print this help message and exit");
    }

    private void run() throws IOException {
        byte[] line = new byte[this.columns];
        char[] hexTable = "0123456789abcdef".toCharArray();
        int offset = 0;
        int count = this.in.read(line);
        while (count != -1) {
            byte value;
            int i;
            String sOffset = Integer.toString(offset, this.radix);
            int pad = 7 - sOffset.length();
            if (pad > 0) {
                this.out.print("0000000".substring(0, pad));
            }
            this.out.print(sOffset + ':');
            for (i = 0; i != count; ++i) {
                if (i % 2 == 0) {
                    this.out.print(' ');
                }
                value = line[i];
                this.out.print(hexTable[value >> 4 & 0xF]);
                this.out.print(hexTable[value & 0xF]);
            }
            this.out.print(' ');
            for (i = 0; i != count; ++i) {
                value = line[i];
                if (value > 0 && value < 128 && !Character.isISOControl((char)value)) {
                    this.out.print((char)value);
                    continue;
                }
                this.out.print('.');
            }
            this.out.println();
            offset += count;
            count = this.in.read(line);
        }
        this.in.close();
        this.out.close();
    }

    public static void main(String[] args) throws IOException {
        new HexDump(args).run();
    }
}

