/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.vm;

import com.sun.squawk.vm.ImageHandle;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;

final class RGBImageHandle
extends ImageHandle {
    private transient Image image;
    private final int hs;
    private final int vs;
    private final int stride;
    private final int[] rgb;

    RGBImageHandle(int hs, int vs, int rgbLength, int stride) {
        this.hs = hs;
        this.vs = vs;
        this.stride = stride;
        this.rgb = new int[rgbLength];
    }

    @Override
    public Image getImage(MediaTracker tracker) {
        if (this.image == null) {
            DirectColorModel colormodel = new DirectColorModel(24, 255, 65280, 0xFF0000);
            MemoryImageSource imageSource = new MemoryImageSource(this.hs, this.vs, (ColorModel)colormodel, this.rgb, 0, this.stride);
            this.image = Toolkit.getDefaultToolkit().createImage(imageSource);
        }
        return this.image;
    }

    void flush(int[] rgb) {
        if (rgb != null) {
            int[] realrgb = this.rgb;
            if (realrgb.length != rgb.length) {
                System.out.println("Bad flushimage rgb buffer length -- realrgb.length = " + realrgb.length + "rgb.length = " + rgb.length);
                System.exit(1);
            }
            System.arraycopy(rgb, 0, realrgb, 0, realrgb.length);
        }
        this.image.flush();
    }
}

