/*
 * Decompiled with CFR 0.152.
 */
import com.sun.squawk.util.Find;
import java.io.File;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;

class jvmenv {
    jvmenv() {
    }

    static String findOne(String dir, String suffix, String match) throws Exception {
        Vector results = new Vector();
        Find.find(new File(dir), suffix, results, false);
        Enumeration e = results.elements();
        while (e.hasMoreElements()) {
            String f = (String)e.nextElement();
            if (f.indexOf(match) == -1) continue;
            return f;
        }
        return null;
    }

    static String findOne(String dir, String suffix, String[] matches) throws Exception {
        String result = null;
        for (int i = 0; i != matches.length && result == null; ++i) {
            result = jvmenv.findOne(dir, suffix, matches[i]);
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        PrintStream out = System.out;
        String jhome = System.getProperty("java.home");
        if (System.getProperty("os.name").startsWith("Windows")) {
            String jvm = jvmenv.findOne(jhome, "jvm.dll", new String[]{"hotspot", "client", ""});
            if (jvm != null) {
                out.println();
                out.println("To configure the environment for Squawk, try the following command:");
                out.println();
                out.println("    set JVMDLL=" + jvm);
                out.println();
            } else {
                out.println();
                out.println("The JVMDLL environment variable must be set to the full path of 'jvm.dll'.");
                out.println();
            }
        } else if (System.getProperty("os.name").equalsIgnoreCase("mac os x")) {
            out.println();
            out.println("There is no need to configure the environment for Squawk on Mac OS X as the location of the");
            out.println("JavaVM framework is built into the executable.");
            out.println();
        } else {
            String jvm = jvmenv.findOne(jhome, "libjvm.so", new String[]{"hotspot", "client", ""});
            String verifier = jvmenv.findOne(jhome, "libverify.so", "");
            if (jvm != null && verifier != null) {
                jvm = new File(jvm).getParent();
                verifier = new File(verifier).getParent();
                out.println();
                out.println("To configure the environment for Squawk, try the following command under bash:");
                out.println();
                out.println("    export LD_LIBRARY_PATH=\"$LD_LIBRARY_PATH:" + jvm + ":" + verifier + "\"");
                out.println();
                out.println("or in csh/tcsh");
                out.println();
                out.println("    setenv LD_LIBRARY_PATH=\"$LD_LIBRARY_PATH:" + jvm + ":" + verifier + "\"");
                out.println();
            } else {
                out.println();
                out.println("The LD_LIBRARY_PATH environment variable must be set to include the directories");
                out.println("containing 'libjvm.so' and 'libverify.so'.");
                out.println();
            }
        }
    }
}

