/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.server;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.server.AbstractReflectiveHandlerMapping;

public class PropertyHandlerMapping
extends AbstractReflectiveHandlerMapping {
    public void load(ClassLoader pClassLoader, String pResource) throws IOException, XmlRpcException {
        URL url = pClassLoader.getResource(pResource);
        if (url == null) {
            throw new IOException("Unable to locate resource " + pResource);
        }
        this.load(pClassLoader, url);
    }

    public void load(ClassLoader pClassLoader, URL pURL) throws IOException, XmlRpcException {
        Properties props = new Properties();
        props.load(pURL.openStream());
        this.load(pClassLoader, props);
    }

    public void load(ClassLoader pClassLoader, Map pMap) throws XmlRpcException {
        for (Map.Entry entry : pMap.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            Class c = this.newHandlerClass(pClassLoader, value);
            this.registerPublicMethods(key, c);
        }
    }

    protected Class newHandlerClass(ClassLoader pClassLoader, String pClassName) throws XmlRpcException {
        Class<?> c;
        try {
            c = pClassLoader.loadClass(pClassName);
        }
        catch (ClassNotFoundException e) {
            throw new XmlRpcException("Unable to load class: " + pClassName, (Throwable)e);
        }
        if (c == null) {
            throw new XmlRpcException(0, "Loading class " + pClassName + " returned null.");
        }
        return c;
    }

    public void addHandler(String pKey, Class pClass) throws XmlRpcException {
        this.registerPublicMethods(pKey, pClass);
    }

    public void removeHandler(String pKey) {
        Iterator i = this.handlerMap.keySet().iterator();
        while (i.hasNext()) {
            String k = (String)i.next();
            if (!k.startsWith(pKey)) continue;
            i.remove();
        }
    }
}

