/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.table_viewer;

import edu.wpi.first.wpilibj.networktables2.NetworkTableNode;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;
import edu.wpi.first.wpilibj.tables.TableKeyNotDefinedException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class NetworkTableTableModel
extends AbstractTableModel
implements ITableListener {
    private final NetworkTableNode node;
    private final List<String> keys = new ArrayList<String>();

    public NetworkTableTableModel(NetworkTableNode networkTableNode) {
        this.node = networkTableNode;
        networkTableNode.addTableListener(this, true);
    }

    @Override
    public void valueChanged(ITable iTable, String string, Object object, boolean bl) {
        if (bl) {
            this.keys.add(string);
            this.fireTableRowsInserted(this.keys.size() - 1, this.keys.size() - 1);
        } else {
            int n = this.keys.indexOf(string);
            this.fireTableRowsUpdated(n, n);
        }
    }

    @Override
    public int getRowCount() {
        return this.keys.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return "Key";
        }
        if (n == 1) {
            return "Value";
        }
        return "Sequence Number";
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.keys.get(n);
        }
        try {
            if (n2 == 1) {
                return this.node.getValue(this.keys.get(n));
            }
            return (int)this.node.getEntryStore().getEntry(this.keys.get(n)).getSequenceNumber();
        }
        catch (TableKeyNotDefinedException tableKeyNotDefinedException) {
            return null;
        }
    }
}

