/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.table_viewer;

import edu.wpi.first.table_viewer.TableViewerFrame;
import edu.wpi.first.wpilibj.networktables2.NetworkTableNode;
import edu.wpi.first.wpilibj.networktables2.client.NetworkTableClient;
import edu.wpi.first.wpilibj.networktables2.server.NetworkTableServer;
import edu.wpi.first.wpilibj.networktables2.stream.IOStreamFactory;
import edu.wpi.first.wpilibj.networktables2.stream.IOStreamProvider;
import edu.wpi.first.wpilibj.networktables2.stream.SocketStreams;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class TableViewerModePrompt
extends JDialog
implements ActionListener {
    private JTextField hostField;
    private JButton launchClientButton;
    private JButton launchServerButton;
    private JButton cancelButton;
    private Preferences prefs;

    public TableViewerModePrompt() {
        String string;
        this.setTitle("Preferences");
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.nimbus.NimbusLookAndFeel");
            this.setBackground(Color.white);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.prefs = Preferences.userNodeForPackage(this.getClass());
        this.setDefaultCloseOperation(2);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 5, 20));
        this.setContentPane(jPanel);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 1;
        this.add((Component)new JLabel("Host: "), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        try {
            string = this.prefs.get("host", "localhost");
        }
        catch (NullPointerException nullPointerException) {
            string = "localhost";
        }
        this.hostField = new JTextField(string);
        this.add((Component)this.hostField, gridBagConstraints);
        this.hostField.addActionListener(this);
        this.hostField.setColumns(20);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        JPanel jPanel2 = new JPanel();
        this.launchClientButton = new JButton("Start client");
        jPanel2.add(this.launchClientButton);
        this.launchClientButton.addActionListener(this);
        this.launchServerButton = new JButton("Start server");
        jPanel2.add(this.launchServerButton);
        this.launchServerButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        jPanel2.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        this.add((Component)jPanel2, gridBagConstraints);
        this.setSize(320, 120);
        this.setMinimumSize(this.getSize());
        this.pack();
    }

    public String getHost() {
        return this.hostField.getText();
    }

    public int getPort() {
        return 1735;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() != this.cancelButton) {
            try {
                Object object;
                NetworkTableNode networkTableNode = null;
                if (actionEvent.getSource() == this.launchServerButton) {
                    object = SocketStreams.newStreamProvider(this.getPort());
                    networkTableNode = new NetworkTableServer((IOStreamProvider)object);
                    this.prefs.put("host", "");
                } else if (actionEvent.getSource() == this.launchClientButton) {
                    object = this.getHost();
                    IOStreamFactory iOStreamFactory = SocketStreams.newStreamFactory((String)object, this.getPort());
                    NetworkTableClient networkTableClient = new NetworkTableClient(iOStreamFactory);
                    networkTableClient.reconnect();
                    networkTableNode = networkTableClient;
                    this.prefs.put("host", (String)object);
                }
                object = new TableViewerFrame(networkTableNode);
                ((Window)object).setVisible(true);
                this.dispose();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, exception.getClass() + ": " + exception.getMessage(), "Error creating table node", 0);
            }
        } else {
            System.exit(0);
        }
    }
}

