/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.table_viewer.tree;

import edu.wpi.first.table_viewer.tree.ITableNode;
import edu.wpi.first.table_viewer.tree.LeafNode;
import edu.wpi.first.wpilibj.tables.ITable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPopupMenu;

public class BranchNode
extends ITableNode {
    private Map<String, ITableNode> entries = new HashMap<String, ITableNode>();

    public BranchNode(ITable iTable) {
        this(iTable, "NetworkTables");
    }

    public BranchNode(ITable iTable, String string) {
        super(iTable, string, true);
        iTable.addTableListener(this, true);
        iTable.addSubTableListener(this);
        this.setAllowsChildren(true);
    }

    @Override
    public void valueChanged(ITable iTable, String string, Object object, boolean bl) {
        if (bl && !this.entries.containsKey(string)) {
            if (object.toString().startsWith("NetworkTable: /")) {
                String string2 = object.toString().substring(iTable.toString().length() + 1);
                BranchNode branchNode = new BranchNode(iTable.getSubTable(string2), string);
                this.add(branchNode);
                this.entries.put(string, branchNode);
            } else {
                LeafNode leafNode = new LeafNode(iTable, string, object);
                this.add(leafNode);
                this.entries.put(string, leafNode);
            }
        }
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public JPopupMenu getMenu() {
        return this.menu;
    }
}

