/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.table_viewer.tree;

import edu.wpi.first.table_viewer.dialog.EditBooleanDialog;
import edu.wpi.first.table_viewer.dialog.EditNumberDialog;
import edu.wpi.first.table_viewer.dialog.EditStringDialog;
import edu.wpi.first.table_viewer.tree.ITableNode;
import edu.wpi.first.table_viewer.tree.TableEntryData;
import edu.wpi.first.wpilibj.tables.ITable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class LeafNode
extends ITableNode {
    private ITable table;
    private String key;
    private boolean insertedEdit = false;

    public LeafNode(ITable iTable, String string, Object object) {
        super(iTable, new TableEntryData(string, object), false);
        iTable.addTableListener(string, this, true);
        this.table = iTable;
        this.key = string;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return ((TableEntryData)this.userObject).getValue();
    }

    public String getType() {
        return ((TableEntryData)this.userObject).getType();
    }

    public void setTableValue(Object object) {
        this.table.putValue(this.key, object);
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public void valueChanged(ITable iTable, String string, Object object, boolean bl) {
        this.setUserObject(new TableEntryData(string, object));
        treeModel.reload(this);
    }

    @Override
    public JPopupMenu getMenu() {
        if (!this.insertedEdit) {
            JMenuItem jMenuItem = new JMenuItem("Edit");
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (LeafNode.this.getType().equals("BOOLEAN")) {
                        new EditBooleanDialog(LeafNode.this).setVisible(true);
                    } else if (LeafNode.this.getType().equals("NUMBER")) {
                        new EditNumberDialog(LeafNode.this).setVisible(true);
                    } else if (LeafNode.this.getType().equals("STRING")) {
                        new EditStringDialog(LeafNode.this).setVisible(true);
                    }
                }
            });
            this.menu.add((Component)jMenuItem, 0);
            this.menu.add((Component)new JSeparator(), 1);
            this.insertedEdit = true;
        }
        return this.menu;
    }
}

