/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.table_viewer.tree;

import edu.wpi.first.table_viewer.dialog.EditBooleanDialog;
import edu.wpi.first.table_viewer.dialog.EditNumberDialog;
import edu.wpi.first.table_viewer.dialog.EditStringDialog;
import edu.wpi.first.table_viewer.tree.BranchNode;
import edu.wpi.first.table_viewer.tree.ITableNode;
import edu.wpi.first.table_viewer.tree.LeafNode;
import edu.wpi.first.wpilibj.networktables.NetworkTableProvider;
import edu.wpi.first.wpilibj.networktables2.NetworkTableNode;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;

public class NetworkTableTree
extends JTree
implements ITableListener {
    private final BranchNode rootNode;

    public NetworkTableTree(NetworkTableNode networkTableNode) {
        ITable iTable = new NetworkTableProvider(networkTableNode).getRootTable();
        ITableNode.setTree(this);
        this.rootNode = new BranchNode(iTable);
        iTable.addTableListener(this, true);
        iTable.addSubTableListener(this);
        ((DefaultTreeModel)this.getModel()).setRoot(this.rootNode);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = NetworkTableTree.this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    int n2 = NetworkTableTree.this.getClosestRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                    NetworkTableTree.this.setSelectionRow(n2);
                    NetworkTableTree.this.handleRightClick(mouseEvent.getX(), mouseEvent.getY());
                }
                if (n != -1 && mouseEvent.getClickCount() == 2) {
                    NetworkTableTree.this.handleDoubleClick();
                }
            }
        };
        this.addMouseListener(mouseAdapter);
    }

    private void handleDoubleClick() {
        ITableNode iTableNode = (ITableNode)this.getSelectionPath().getLastPathComponent();
        if (iTableNode instanceof LeafNode) {
            if (((LeafNode)iTableNode).getType().equalsIgnoreCase("number")) {
                new EditNumberDialog((LeafNode)iTableNode).setVisible(true);
            } else if (((LeafNode)iTableNode).getType().equalsIgnoreCase("string")) {
                new EditStringDialog((LeafNode)iTableNode).setVisible(true);
            } else if (((LeafNode)iTableNode).getType().equalsIgnoreCase("boolean")) {
                new EditBooleanDialog((LeafNode)iTableNode).setVisible(true);
            }
        }
    }

    private void handleRightClick(int n, int n2) {
        ITableNode iTableNode = (ITableNode)this.getSelectionPath().getLastPathComponent();
        System.out.println("Right click at [" + n + "," + n2 + "] on node " + iTableNode);
        JPopupMenu jPopupMenu = iTableNode.getMenu();
        jPopupMenu.show(this, n, n2);
    }

    @Override
    public void valueChanged(ITable iTable, String string, Object object, boolean bl) {
        System.out.println(string + " changed to " + object);
        ((DefaultTreeModel)this.getModel()).reload();
    }
}

