/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.table_viewer.tree;

import java.text.DecimalFormat;
import java.util.Arrays;

public class TableEntryData {
    private Object key;
    private Object value;
    private Object type;
    private final String space = "          ";

    public TableEntryData(String string, Object object) {
        this.key = string;
        try {
            this.value = new ArrayWrapper(object);
        }
        catch (Exception exception) {
            if (object instanceof Number) {
                DecimalFormat decimalFormat = new DecimalFormat("#.#####");
                String string2 = decimalFormat.format((Double)object);
                this.value = string2;
            }
            this.value = object;
        }
        this.type = this.typeFromValue(object);
    }

    public String getKey() {
        return this.key.toString();
    }

    public String getValue() {
        return this.value.toString();
    }

    public String getType() {
        return this.type.toString();
    }

    public String toString() {
        return this.key + "          " + this.value + "          " + this.type;
    }

    private String typeFromValue(Object object) {
        String string = object.getClass().toString().substring(object.getClass().toString().lastIndexOf(".") + 1);
        switch (string.toLowerCase()) {
            case "boolean": {
                return "BOOLEAN";
            }
            case "double": {
                return "NUMBER";
            }
            case "string": {
                return "STRING";
            }
            case "object;": {
                return "ARRAY";
            }
        }
        return string.toUpperCase();
    }

    private class ArrayWrapper {
        private Object[] array;

        ArrayWrapper(Object object) throws Exception {
            if (!(object instanceof Object[])) {
                throw new RuntimeException();
            }
            this.array = (Object[])object;
        }

        public String toString() {
            String string = Arrays.toString(this.array);
            if (string.length() > 2) {
                return string.substring(1, string.length() - 1);
            }
            return "Empty";
        }
    }
}

