/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables2;

import edu.wpi.first.wpilibj.networktables2.AbstractNetworkTableEntryStore;
import edu.wpi.first.wpilibj.networktables2.FlushableOutgoingEntryReceiver;
import edu.wpi.first.wpilibj.networktables2.NetworkTableEntry;
import edu.wpi.first.wpilibj.networktables2.OutgoingEntryReceiver;
import edu.wpi.first.wpilibj.networktables2.thread.NTThread;
import edu.wpi.first.wpilibj.networktables2.thread.NTThreadManager;
import edu.wpi.first.wpilibj.networktables2.thread.PeriodicRunnable;
import edu.wpi.first.wpilibj.networktables2.util.HalfQueue;

public class WriteManager
implements OutgoingEntryReceiver,
PeriodicRunnable {
    private final int SLEEP_TIME = 100;
    private final int queueSize = 500;
    private Object transactionsLock = new Object();
    private NTThread thread;
    private NTThreadManager threadManager;
    private final AbstractNetworkTableEntryStore entryStore;
    private volatile HalfQueue incomingAssignmentQueue;
    private volatile HalfQueue incomingUpdateQueue;
    private volatile HalfQueue outgoingAssignmentQueue;
    private volatile HalfQueue outgoingUpdateQueue;
    private FlushableOutgoingEntryReceiver receiver;
    private long lastWrite;
    private final long keepAliveDelay;

    public WriteManager(FlushableOutgoingEntryReceiver flushableOutgoingEntryReceiver, NTThreadManager nTThreadManager, AbstractNetworkTableEntryStore abstractNetworkTableEntryStore, long l) {
        this.receiver = flushableOutgoingEntryReceiver;
        this.threadManager = nTThreadManager;
        this.entryStore = abstractNetworkTableEntryStore;
        this.incomingAssignmentQueue = new HalfQueue(500);
        this.incomingUpdateQueue = new HalfQueue(500);
        this.outgoingAssignmentQueue = new HalfQueue(500);
        this.outgoingUpdateQueue = new HalfQueue(500);
        this.keepAliveDelay = l;
    }

    public void start() {
        if (this.thread != null) {
            this.stop();
        }
        this.lastWrite = System.currentTimeMillis();
        this.thread = this.threadManager.newBlockingPeriodicThread(this, "Write Manager Thread");
    }

    public void stop() {
        if (this.thread != null) {
            this.thread.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void offerOutgoingAssignment(NetworkTableEntry networkTableEntry) {
        Object object = this.transactionsLock;
        synchronized (object) {
            this.incomingAssignmentQueue.queue(networkTableEntry);
            if (this.incomingAssignmentQueue.isFull()) {
                try {
                    this.run();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.err.println("assignment queue overflowed. decrease the rate at which you create new entries or increase the write buffer size");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void offerOutgoingUpdate(NetworkTableEntry networkTableEntry) {
        Object object = this.transactionsLock;
        synchronized (object) {
            this.incomingUpdateQueue.queue(networkTableEntry);
            if (this.incomingUpdateQueue.isFull()) {
                try {
                    this.run();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.err.println("update queue overflowed. decrease the rate at which you update entries or increase the write buffer size");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws InterruptedException {
        AbstractNetworkTableEntryStore abstractNetworkTableEntryStore;
        int n;
        Object object;
        Object object2 = this.transactionsLock;
        synchronized (object2) {
            object = this.incomingAssignmentQueue;
            this.incomingAssignmentQueue = this.outgoingAssignmentQueue;
            this.outgoingAssignmentQueue = object;
            object = this.incomingUpdateQueue;
            this.incomingUpdateQueue = this.outgoingUpdateQueue;
            this.outgoingUpdateQueue = object;
        }
        boolean bl = false;
        int n2 = this.outgoingAssignmentQueue.size();
        Object[] objectArray = this.outgoingAssignmentQueue.array;
        for (n = 0; n < n2; ++n) {
            object = (NetworkTableEntry)objectArray[n];
            abstractNetworkTableEntryStore = this.entryStore;
            synchronized (abstractNetworkTableEntryStore) {
                ((NetworkTableEntry)object).makeClean();
            }
            bl = true;
            this.receiver.offerOutgoingAssignment((NetworkTableEntry)object);
        }
        this.outgoingAssignmentQueue.clear();
        n2 = this.outgoingUpdateQueue.size();
        objectArray = this.outgoingUpdateQueue.array;
        for (n = 0; n < n2; ++n) {
            object = (NetworkTableEntry)objectArray[n];
            abstractNetworkTableEntryStore = this.entryStore;
            synchronized (abstractNetworkTableEntryStore) {
                ((NetworkTableEntry)object).makeClean();
            }
            bl = true;
            this.receiver.offerOutgoingUpdate((NetworkTableEntry)object);
        }
        this.outgoingUpdateQueue.clear();
        if (bl) {
            this.receiver.flush();
            this.lastWrite = System.currentTimeMillis();
        } else if (System.currentTimeMillis() - this.lastWrite > this.keepAliveDelay) {
            this.receiver.ensureAlive();
        }
        Thread.sleep(100L);
    }
}

