/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables2.client;

import edu.wpi.first.wpilibj.networktables2.FlushableOutgoingEntryReceiver;
import edu.wpi.first.wpilibj.networktables2.IncomingEntryReceiver;
import edu.wpi.first.wpilibj.networktables2.NetworkTableEntry;
import edu.wpi.first.wpilibj.networktables2.client.ClientConnectionListenerManager;
import edu.wpi.first.wpilibj.networktables2.client.ClientConnectionState;
import edu.wpi.first.wpilibj.networktables2.client.ClientNetworkTableEntryStore;
import edu.wpi.first.wpilibj.networktables2.connection.BadMessageException;
import edu.wpi.first.wpilibj.networktables2.connection.ConnectionAdapter;
import edu.wpi.first.wpilibj.networktables2.connection.ConnectionMonitorThread;
import edu.wpi.first.wpilibj.networktables2.connection.NetworkTableConnection;
import edu.wpi.first.wpilibj.networktables2.stream.IOStream;
import edu.wpi.first.wpilibj.networktables2.stream.IOStreamFactory;
import edu.wpi.first.wpilibj.networktables2.thread.NTThread;
import edu.wpi.first.wpilibj.networktables2.thread.NTThreadManager;
import edu.wpi.first.wpilibj.networktables2.type.NetworkTableEntryTypeManager;
import java.io.IOException;

public class ClientConnectionAdapter
implements ConnectionAdapter,
IncomingEntryReceiver,
FlushableOutgoingEntryReceiver {
    private final ClientNetworkTableEntryStore entryStore;
    private final IOStreamFactory streamFactory;
    private final NTThreadManager threadManager;
    private NetworkTableConnection connection;
    private NTThread readThread;
    private ClientConnectionState connectionState = ClientConnectionState.DISCONNECTED_FROM_SERVER;
    private final ClientConnectionListenerManager connectionListenerManager;
    private final Object connectionLock = new Object();
    private final NetworkTableEntryTypeManager typeManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gotoState(ClientConnectionState clientConnectionState) {
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.connectionState != clientConnectionState) {
                System.out.println(this + " entered connection state: " + clientConnectionState);
                if (clientConnectionState == ClientConnectionState.IN_SYNC_WITH_SERVER) {
                    this.connectionListenerManager.fireConnectedEvent();
                }
                if (this.connectionState == ClientConnectionState.IN_SYNC_WITH_SERVER) {
                    this.connectionListenerManager.fireDisconnectedEvent();
                }
                this.connectionState = clientConnectionState;
            }
        }
    }

    public ClientConnectionState getConnectionState() {
        return this.connectionState;
    }

    public boolean isConnected() {
        return this.getConnectionState() == ClientConnectionState.IN_SYNC_WITH_SERVER;
    }

    public ClientConnectionAdapter(ClientNetworkTableEntryStore clientNetworkTableEntryStore, NTThreadManager nTThreadManager, IOStreamFactory iOStreamFactory, ClientConnectionListenerManager clientConnectionListenerManager, NetworkTableEntryTypeManager networkTableEntryTypeManager) {
        this.entryStore = clientNetworkTableEntryStore;
        this.streamFactory = iOStreamFactory;
        this.threadManager = nTThreadManager;
        this.connectionListenerManager = clientConnectionListenerManager;
        this.typeManager = networkTableEntryTypeManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect() {
        Object object = this.connectionLock;
        synchronized (object) {
            this.close();
            try {
                IOStream iOStream = this.streamFactory.createStream();
                if (iOStream == null) {
                    return;
                }
                this.connection = new NetworkTableConnection(iOStream, this.typeManager);
                this.readThread = this.threadManager.newBlockingPeriodicThread(new ConnectionMonitorThread(this, this.connection), "Client Connection Reader Thread");
                this.connection.sendClientHello();
                this.gotoState(ClientConnectionState.CONNECTED_TO_SERVER);
            }
            catch (Exception exception) {
                this.close();
            }
        }
    }

    public void close() {
        this.close(ClientConnectionState.DISCONNECTED_FROM_SERVER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(ClientConnectionState clientConnectionState) {
        Object object = this.connectionLock;
        synchronized (object) {
            this.gotoState(clientConnectionState);
            if (this.readThread != null) {
                this.readThread.stop();
                this.readThread = null;
            }
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
            this.entryStore.clearIds();
        }
    }

    @Override
    public void badMessage(BadMessageException badMessageException) {
        this.close(new ClientConnectionState.Error(badMessageException));
    }

    @Override
    public void ioException(IOException iOException) {
        if (this.connectionState != ClientConnectionState.DISCONNECTED_FROM_SERVER) {
            this.reconnect();
        }
    }

    @Override
    public NetworkTableEntry getEntry(char c) {
        return this.entryStore.getEntry(c);
    }

    @Override
    public void keepAlive() throws IOException {
    }

    @Override
    public void clientHello(char c) throws IOException {
        throw new BadMessageException("A client should not receive a client hello message");
    }

    @Override
    public void protocolVersionUnsupported(char c) {
        this.close();
        this.gotoState(new ClientConnectionState.ProtocolUnsuppotedByServer(c));
    }

    @Override
    public void serverHelloComplete() throws IOException {
        if (this.connectionState == ClientConnectionState.CONNECTED_TO_SERVER) {
            try {
                this.gotoState(ClientConnectionState.IN_SYNC_WITH_SERVER);
                this.entryStore.sendUnknownEntries(this.connection);
            }
            catch (IOException iOException) {
                this.ioException(iOException);
            }
        } else {
            throw new BadMessageException("A client should only receive a server hello complete once and only after it has connected to the server");
        }
    }

    @Override
    public void offerIncomingAssignment(NetworkTableEntry networkTableEntry) {
        this.entryStore.offerIncomingAssignment(networkTableEntry);
    }

    @Override
    public void offerIncomingUpdate(NetworkTableEntry networkTableEntry, char c, Object object) {
        this.entryStore.offerIncomingUpdate(networkTableEntry, c, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void offerOutgoingAssignment(NetworkTableEntry networkTableEntry) {
        try {
            Object object = this.connectionLock;
            synchronized (object) {
                if (this.connection != null && this.connectionState == ClientConnectionState.IN_SYNC_WITH_SERVER) {
                    this.connection.sendEntryAssignment(networkTableEntry);
                }
            }
        }
        catch (IOException iOException) {
            this.ioException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void offerOutgoingUpdate(NetworkTableEntry networkTableEntry) {
        try {
            Object object = this.connectionLock;
            synchronized (object) {
                if (this.connection != null && this.connectionState == ClientConnectionState.IN_SYNC_WITH_SERVER) {
                    this.connection.sendEntryUpdate(networkTableEntry);
                }
            }
        }
        catch (IOException iOException) {
            this.ioException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.connection != null) {
                try {
                    this.connection.flush();
                }
                catch (IOException iOException) {
                    this.ioException(iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ensureAlive() {
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.connection != null) {
                try {
                    this.connection.sendKeepAlive();
                }
                catch (IOException iOException) {
                    this.ioException(iOException);
                }
            } else {
                this.reconnect();
            }
        }
    }
}

