/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables2.client;

import edu.wpi.first.wpilibj.networktables2.NetworkTableNode;
import edu.wpi.first.wpilibj.networktables2.OutgoingEntryReceiver;
import edu.wpi.first.wpilibj.networktables2.TransactionDirtier;
import edu.wpi.first.wpilibj.networktables2.WriteManager;
import edu.wpi.first.wpilibj.networktables2.client.ClientConnectionAdapter;
import edu.wpi.first.wpilibj.networktables2.client.ClientNetworkTableEntryStore;
import edu.wpi.first.wpilibj.networktables2.stream.IOStreamFactory;
import edu.wpi.first.wpilibj.networktables2.thread.DefaultThreadManager;
import edu.wpi.first.wpilibj.networktables2.thread.NTThreadManager;
import edu.wpi.first.wpilibj.networktables2.type.NetworkTableEntryTypeManager;

public class NetworkTableClient
extends NetworkTableNode {
    private final ClientConnectionAdapter adapter;
    private final WriteManager writeManager;

    public NetworkTableClient(IOStreamFactory iOStreamFactory, NetworkTableEntryTypeManager networkTableEntryTypeManager, NTThreadManager nTThreadManager) {
        ClientNetworkTableEntryStore clientNetworkTableEntryStore = new ClientNetworkTableEntryStore(this);
        this.init(clientNetworkTableEntryStore);
        this.adapter = new ClientConnectionAdapter(clientNetworkTableEntryStore, nTThreadManager, iOStreamFactory, this, networkTableEntryTypeManager);
        this.writeManager = new WriteManager(this.adapter, nTThreadManager, this.getEntryStore(), 1000L);
        this.getEntryStore().setOutgoingReceiver(new TransactionDirtier(this.writeManager));
        this.getEntryStore().setIncomingReceiver(OutgoingEntryReceiver.NULL);
        this.writeManager.start();
    }

    public NetworkTableClient(IOStreamFactory iOStreamFactory) {
        this(iOStreamFactory, new NetworkTableEntryTypeManager(), new DefaultThreadManager());
    }

    public void reconnect() {
        this.adapter.reconnect();
    }

    @Override
    public void close() {
        this.adapter.close();
    }

    public void stop() {
        this.writeManager.stop();
        this.close();
    }

    @Override
    public boolean isConnected() {
        return this.adapter.isConnected();
    }

    @Override
    public boolean isServer() {
        return false;
    }
}

