/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables2.server;

import edu.wpi.first.wpilibj.networktables2.FlushableOutgoingEntryReceiver;
import edu.wpi.first.wpilibj.networktables2.IncomingEntryReceiver;
import edu.wpi.first.wpilibj.networktables2.NetworkTableEntry;
import edu.wpi.first.wpilibj.networktables2.connection.BadMessageException;
import edu.wpi.first.wpilibj.networktables2.connection.ConnectionAdapter;
import edu.wpi.first.wpilibj.networktables2.connection.ConnectionMonitorThread;
import edu.wpi.first.wpilibj.networktables2.connection.NetworkTableConnection;
import edu.wpi.first.wpilibj.networktables2.server.ServerAdapterManager;
import edu.wpi.first.wpilibj.networktables2.server.ServerConnectionState;
import edu.wpi.first.wpilibj.networktables2.server.ServerNetworkTableEntryStore;
import edu.wpi.first.wpilibj.networktables2.stream.IOStream;
import edu.wpi.first.wpilibj.networktables2.thread.NTThread;
import edu.wpi.first.wpilibj.networktables2.thread.NTThreadManager;
import edu.wpi.first.wpilibj.networktables2.type.NetworkTableEntryTypeManager;
import java.io.EOFException;
import java.io.IOException;

public class ServerConnectionAdapter
implements ConnectionAdapter,
IncomingEntryReceiver,
FlushableOutgoingEntryReceiver {
    private final ServerNetworkTableEntryStore entryStore;
    private final IncomingEntryReceiver transactionReceiver;
    private final ServerAdapterManager adapterListener;
    public final NetworkTableConnection connection;
    private final NTThread readThread;
    private ServerConnectionState connectionState;

    private void gotoState(ServerConnectionState serverConnectionState) {
        if (this.connectionState != serverConnectionState) {
            System.out.println(this + " entered connection state: " + serverConnectionState);
            this.connectionState = serverConnectionState;
        }
    }

    public ServerConnectionAdapter(IOStream iOStream, ServerNetworkTableEntryStore serverNetworkTableEntryStore, IncomingEntryReceiver incomingEntryReceiver, ServerAdapterManager serverAdapterManager, NetworkTableEntryTypeManager networkTableEntryTypeManager, NTThreadManager nTThreadManager) {
        this.connection = new NetworkTableConnection(iOStream, networkTableEntryTypeManager);
        this.entryStore = serverNetworkTableEntryStore;
        this.transactionReceiver = incomingEntryReceiver;
        this.adapterListener = serverAdapterManager;
        this.gotoState(ServerConnectionState.GOT_CONNECTION_FROM_CLIENT);
        this.readThread = nTThreadManager.newBlockingPeriodicThread(new ConnectionMonitorThread(this, this.connection), "Server Connection Reader Thread");
    }

    @Override
    public void badMessage(BadMessageException badMessageException) {
        this.gotoState(new ServerConnectionState.Error(badMessageException));
        this.adapterListener.close(this, true);
    }

    @Override
    public void ioException(IOException iOException) {
        if (iOException instanceof EOFException) {
            this.gotoState(ServerConnectionState.CLIENT_DISCONNECTED);
        } else {
            this.gotoState(new ServerConnectionState.Error(iOException));
        }
        this.adapterListener.close(this, false);
    }

    public void shutdown(boolean bl) {
        this.readThread.stop();
        if (bl) {
            this.connection.close();
        }
    }

    @Override
    public void keepAlive() throws IOException {
    }

    @Override
    public void clientHello(char c) throws IOException {
        if (this.connectionState != ServerConnectionState.GOT_CONNECTION_FROM_CLIENT) {
            throw new BadMessageException("A server should not receive a client hello after it has already connected/entered an error state");
        }
        if (c != '\u0200') {
            this.connection.sendProtocolVersionUnsupported();
            throw new BadMessageException("Client Connected with bad protocol revision: 0x" + Integer.toHexString(c));
        }
        this.entryStore.sendServerHello(this.connection);
        this.gotoState(ServerConnectionState.CONNECTED_TO_CLIENT);
    }

    @Override
    public void protocolVersionUnsupported(char c) throws IOException {
        throw new BadMessageException("A server should not receive a protocol version unsupported message");
    }

    @Override
    public void serverHelloComplete() throws IOException {
        throw new BadMessageException("A server should not receive a server hello complete message");
    }

    @Override
    public void offerIncomingAssignment(NetworkTableEntry networkTableEntry) {
        this.transactionReceiver.offerIncomingAssignment(networkTableEntry);
    }

    @Override
    public void offerIncomingUpdate(NetworkTableEntry networkTableEntry, char c, Object object) {
        this.transactionReceiver.offerIncomingUpdate(networkTableEntry, c, object);
    }

    @Override
    public NetworkTableEntry getEntry(char c) {
        return this.entryStore.getEntry(c);
    }

    @Override
    public void offerOutgoingAssignment(NetworkTableEntry networkTableEntry) {
        try {
            if (this.connectionState == ServerConnectionState.CONNECTED_TO_CLIENT) {
                this.connection.sendEntryAssignment(networkTableEntry);
            }
        }
        catch (IOException iOException) {
            this.ioException(iOException);
        }
    }

    @Override
    public void offerOutgoingUpdate(NetworkTableEntry networkTableEntry) {
        try {
            if (this.connectionState == ServerConnectionState.CONNECTED_TO_CLIENT) {
                this.connection.sendEntryUpdate(networkTableEntry);
            }
        }
        catch (IOException iOException) {
            this.ioException(iOException);
        }
    }

    @Override
    public void flush() {
        try {
            this.connection.flush();
        }
        catch (IOException iOException) {
            this.ioException(iOException);
        }
    }

    public ServerConnectionState getConnectionState() {
        return this.connectionState;
    }

    @Override
    public void ensureAlive() {
        try {
            this.connection.sendKeepAlive();
        }
        catch (IOException iOException) {
            this.ioException(iOException);
        }
    }
}

