/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables2.type;

import edu.wpi.first.wpilibj.networktables2.TableKeyExistsWithDifferentTypeException;
import edu.wpi.first.wpilibj.networktables2.type.ArrayData;
import edu.wpi.first.wpilibj.networktables2.type.ComplexEntryType;
import edu.wpi.first.wpilibj.networktables2.type.NetworkTableEntryType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ArrayEntryType
extends ComplexEntryType {
    private final NetworkTableEntryType elementType;
    private final Class externalArrayType;

    public ArrayEntryType(byte by, NetworkTableEntryType networkTableEntryType, Class clazz) {
        super(by, "Array of [" + networkTableEntryType.name + "]");
        if (!ArrayData.class.isAssignableFrom(clazz)) {
            throw new RuntimeException("External Array Data Type must extend ArrayData");
        }
        this.externalArrayType = clazz;
        this.elementType = networkTableEntryType;
    }

    @Override
    public void sendValue(Object object, DataOutputStream dataOutputStream) throws IOException {
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            if (objectArray.length > 255) {
                throw new IOException("Cannot write " + object + " as " + this.name + ". Arrays have a max length of 255 values");
            }
            dataOutputStream.writeByte(objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                this.elementType.sendValue(objectArray[i], dataOutputStream);
            }
        } else {
            throw new IOException("Cannot write " + object + " as " + this.name);
        }
    }

    @Override
    public Object readValue(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedByte();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.elementType.readValue(dataInputStream);
        }
        return objectArray;
    }

    @Override
    public Object internalizeValue(String string, Object object, Object object2) {
        if (this.externalArrayType.isInstance(object)) {
            Object[] objectArray;
            ArrayData arrayData = (ArrayData)object;
            if (object2 instanceof Object[] && (objectArray = (Object[])object2).length == arrayData.size()) {
                System.arraycopy(arrayData.getDataArray(), 0, objectArray, 0, objectArray.length);
                return objectArray;
            }
            objectArray = new Object[arrayData.size()];
            System.arraycopy(arrayData.getDataArray(), 0, objectArray, 0, objectArray.length);
            return objectArray;
        }
        throw new TableKeyExistsWithDifferentTypeException(string, this, object + " is not a " + this.externalArrayType);
    }

    @Override
    public void exportValue(String string, Object object, Object object2) {
        if (!this.externalArrayType.isInstance(object2)) {
            throw new TableKeyExistsWithDifferentTypeException(string, this, object2 + " is not a " + this.externalArrayType);
        }
        if (!(object instanceof Object[])) {
            throw new TableKeyExistsWithDifferentTypeException(string, this, "Internal data: " + object + " is not an array");
        }
        Object[] objectArray = (Object[])object;
        ArrayData arrayData = (ArrayData)object2;
        arrayData.setSize(objectArray.length);
        System.arraycopy(objectArray, 0, arrayData.getDataArray(), 0, objectArray.length);
    }
}

