/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.TreeMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.ClassloaderBase;
import org.apache.tools.ant.taskdefs.classloader.ClassloaderContext;
import org.apache.tools.ant.taskdefs.classloader.report.AbstractFormattedReporter;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReportBuilder;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReportFlattenBuilder;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReportFormatter;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReportHandle;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReportTextFormatter;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReportTreeBuilder;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReportUtil;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReportXMLFormatter;
import org.apache.tools.ant.taskdefs.classloader.report.FormattedAntLoggerReporter;
import org.apache.tools.ant.taskdefs.classloader.report.FormattedPrintStreamReporter;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class ClassloaderReport
extends ClassloaderBase
implements ClassloaderContext.Report {
    private Format format = null;
    private Hierarchy hierarchy = null;
    private boolean reportPackages = true;
    private File output = null;

    public ClassloaderReport() {
        this.setFailonerror(false);
    }

    public void execute() {
        AbstractFormattedReporter abstractFormattedReporter;
        Object object;
        Object object2;
        HashMap hashMap = new HashMap();
        TreeMap treeMap = new TreeMap();
        if (this.format == null) {
            Format format = this.format = this.output == null ? new Format("txt") : new Format("xml");
        }
        if (this.hierarchy == null) {
            this.hierarchy = this.format.getDefaultHierarchy();
        }
        ClassloaderReportBuilder classloaderReportBuilder = this.hierarchy.newBuilder(this);
        boolean bl = true;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader().getParent();
        ClassloaderReportUtil classloaderReportUtil = ClassloaderReportUtil.getReportUtil();
        if (classLoader != null && classLoader.getClass().getName().equals("sun.misc.Launcher$ExtClassLoader") && !classloaderReportUtil.addLoaderToReport(this, classLoader, ClassloaderReportHandle.EXTENSIONHANDLE, hashMap, treeMap, classloaderReportBuilder)) {
            bl = false;
        }
        if (!classloaderReportUtil.addLoaderToReport(this, ClassLoader.getSystemClassLoader(), ClassloaderReportHandle.SYSTEMHANDLE, hashMap, treeMap, classloaderReportBuilder)) {
            bl = false;
        }
        if (!classloaderReportUtil.addLoaderToReport(this, this.getProject().getClass().getClassLoader(), ClassloaderReportHandle.PROJECTHANDLE, hashMap, treeMap, classloaderReportBuilder)) {
            bl = false;
        }
        if (!classloaderReportUtil.addLoaderToReport(this, this.getClass().getClassLoader(), ClassloaderReportHandle.CURRENTHANDLE, hashMap, treeMap, classloaderReportBuilder)) {
            bl = false;
        }
        if (!classloaderReportUtil.addLoaderToReport(this, Thread.currentThread().getContextClassLoader(), ClassloaderReportHandle.THREADHANDLE, hashMap, treeMap, classloaderReportBuilder)) {
            bl = false;
        }
        if (!classloaderReportUtil.addLoaderToReport(this, this.getProject().getCoreLoader(), ClassloaderReportHandle.COREHANDLE, hashMap, treeMap, classloaderReportBuilder)) {
            bl = false;
        }
        Object[] objectArray = this.getProject().getReferences().keySet().toArray(new String[this.getProject().getReferences().size()]);
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            object2 = this.getProject().getReference((String)objectArray[i]);
            if (!(object2 instanceof ClassLoader) || classloaderReportUtil.addLoaderToReport(this, (ClassLoader)object2, new ClassloaderReportHandle(7, (String)objectArray[i]), hashMap, treeMap, classloaderReportBuilder)) continue;
            bl = false;
        }
        ComponentHelper componentHelper = ComponentHelper.getComponentHelper((Project)this.getProject());
        object2 = componentHelper.getAntTypeTable();
        objectArray = object2.keySet().toArray(new String[object2.size()]);
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            object = componentHelper.getDefinition((String)objectArray[i]);
            if (object.getClassLoader() == null || classloaderReportUtil.addLoaderToReport(this, object.getClassLoader(), new ClassloaderReportHandle(8, (String)objectArray[i]), hashMap, treeMap, classloaderReportBuilder)) continue;
            bl = false;
        }
        objectArray = null;
        classloaderReportUtil.report((ClassloaderContext.Report)this, hashMap, treeMap, classloaderReportBuilder, bl);
        object = null;
        if (this.output != null) {
            try {
                object = new PrintStream(new FileOutputStream(this.output));
                abstractFormattedReporter = new FormattedPrintStreamReporter(this.format.newFormatter(), (PrintStream)object);
            }
            catch (IOException iOException) {
                throw new BuildException((Throwable)iOException);
            }
        } else {
            abstractFormattedReporter = new FormattedAntLoggerReporter(this, this.format.newFormatter());
        }
        classloaderReportBuilder.execute(abstractFormattedReporter);
        if (object != null) {
            ((PrintStream)object).close();
        }
    }

    public boolean isReportPackages() {
        return this.reportPackages;
    }

    public void setDestfile(File file) {
        this.output = file;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public void setHierarchy(Hierarchy hierarchy) {
        this.hierarchy = hierarchy;
    }

    public void setReportpackages(boolean bl) {
        this.reportPackages = bl;
    }

    public static class Hierarchy
    extends EnumeratedAttribute {
        private static final int FLAT = 0;
        private static final int TREE = 1;

        public Hierarchy() {
        }

        public Hierarchy(String string) {
            this.setValue(string);
        }

        public ClassloaderReportBuilder newBuilder(ClassloaderContext.Report report) {
            switch (this.getIndex()) {
                case 0: {
                    return new ClassloaderReportFlattenBuilder(report);
                }
                case 1: {
                    return new ClassloaderReportTreeBuilder(report);
                }
            }
            return null;
        }

        public String[] getValues() {
            return new String[]{"flat", "tree"};
        }
    }

    public static class Format
    extends EnumeratedAttribute {
        private static final int XML = 0;
        private static final int TXT = 1;

        public Format() {
        }

        public Format(String string) {
            this.setValue(string);
        }

        public ClassloaderReportFormatter newFormatter() {
            switch (this.getIndex()) {
                case 0: {
                    return new ClassloaderReportXMLFormatter();
                }
                case 1: {
                    return new ClassloaderReportTextFormatter();
                }
            }
            return null;
        }

        public Hierarchy getDefaultHierarchy() {
            switch (this.getIndex()) {
                case 0: {
                    return new Hierarchy("tree");
                }
                case 1: {
                    return new Hierarchy("flat");
                }
            }
            return null;
        }

        public String[] getValues() {
            return new String[]{"xml", "txt"};
        }
    }
}

