/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.ClassloaderBase;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderAdapter;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderAdapterAction;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderHandler;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderParameters;
import org.apache.tools.ant.taskdefs.classloader.ClassloaderAdapterException;
import org.apache.tools.ant.taskdefs.classloader.ClassloaderContext;
import org.apache.tools.ant.types.AntLoaderParameters;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.LoaderHandler;
import org.apache.tools.ant.types.LoaderHandlerSet;
import org.apache.tools.ant.types.LoaderParameters;
import org.apache.tools.ant.types.LoaderRef;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.URLPath;

public class ClassloaderTask
extends ClassloaderBase
implements ClassloaderContext.CreateModify {
    private URLPath classpath = null;
    private DuplicateEntry duplicateEntry = new DuplicateEntry("omit");
    private ClassLoaderHandler handler = null;
    private LoaderRef loader = null;
    private String loaderName = null;
    private ClassLoaderParameters parameters = null;
    private LoaderRef parentLoader = null;
    private String property = null;
    private boolean reset = false;
    private LoaderRef superLoader = null;

    public void addAntParameters(AntLoaderParameters antLoaderParameters) {
        this.parameters = antLoaderParameters;
    }

    public void addConfiguredHandler(LoaderHandler loaderHandler) {
        loaderHandler.check();
        if (this.handler != null) {
            throw new BuildException("nested element handler can only specified once");
        }
        this.handler = loaderHandler;
    }

    public void addLoader(LoaderRef loaderRef) {
        if (loaderRef.isStandardLoader(3)) {
            throw new BuildException("nested element loader can not be 'none'");
        }
        this.loader = loaderRef;
    }

    public void addParameters(LoaderParameters loaderParameters) {
        this.parameters = loaderParameters;
    }

    public void addParentLoader(LoaderRef loaderRef) {
        this.parentLoader = loaderRef;
    }

    public void addSuperLoader(LoaderRef loaderRef) {
        this.superLoader = loaderRef;
    }

    public URLPath createClasspath() {
        if (this.classpath == null) {
            this.classpath = new URLPath(this.getProject());
        }
        return this.classpath.createUrlpath();
    }

    public void execute() {
        if (this.loader == null) {
            throw new BuildException("no loader specified");
        }
        if (!this.executeCreateModify()) {
            return;
        }
        if (this.property != null) {
            this.executeProperty();
        }
    }

    private boolean executeCreateModify() {
        boolean bl;
        URLPath uRLPath = this.getClasspath();
        ClassLoader classLoader = null;
        if (!this.reset) {
            classLoader = this.loader.getClassLoader(null, false, true);
        }
        boolean bl2 = classLoader == null;
        boolean bl3 = bl = classLoader != null && uRLPath != null;
        if (!bl2 && !bl) {
            return true;
        }
        if ("only".equals(this.getProject().getProperty("build.sysclasspath")) && this.loader.equalsSysLoader()) {
            this.log("Changing " + this.loader.getName() + " is disabled " + "by build.sysclasspath=only", 1);
            return true;
        }
        if (this.reset && !this.loader.isResetPossible()) {
            this.handleError("reseting " + this.loader.getName() + " is not possible");
            return false;
        }
        if (bl2 && !this.loader.isResetPossible()) {
            this.handleError("creating " + this.loader.getName() + " is not possible");
            return false;
        }
        this.log("handling " + this.getLoaderName() + ": " + (classLoader == null ? "not " : "") + "found, cp=" + this.getClasspath(), 4);
        if (classLoader == null) {
            ClassLoaderHandler classLoaderHandler = this.getHandler();
            if (classLoaderHandler == null) {
                throw new BuildException("internal error: handler is null");
            }
            ClassLoaderAdapter classLoaderAdapter = classLoaderHandler.getAdapter(this);
            if (classLoaderAdapter == null) {
                return false;
            }
            classLoader = classLoaderAdapter.createClassLoader(this);
            if (classLoader == null) {
                return false;
            }
            this.loader.setClassLoader(classLoader);
        } else if (uRLPath != null) {
            ClassLoaderAdapter classLoaderAdapter;
            try {
                classLoaderAdapter = this.getUtil().findAdapter(this, classLoader, ClassLoaderAdapterAction.APPEND);
            }
            catch (ClassloaderAdapterException classloaderAdapterException) {
                switch (classloaderAdapterException.getReason()) {
                    case 1: {
                        this.log("NO HANDLER", 4);
                        return false;
                    }
                    case 2: {
                        this.log("NO ADAPTER", 4);
                        return false;
                    }
                }
                throw new BuildException("unexpected reason " + classloaderAdapterException.getReason(), (Throwable)classloaderAdapterException);
            }
            if (!classLoaderAdapter.appendClasspath(this, classLoader)) {
                this.log("NO APPEND", 4);
                return false;
            }
        }
        return true;
    }

    private boolean executeProperty() {
        ClassLoaderAdapter classLoaderAdapter;
        ClassLoader classLoader = this.loader.getClassLoader(null);
        try {
            classLoaderAdapter = this.getUtil().findAdapter(this, classLoader, ClassLoaderAdapterAction.GETPATH);
        }
        catch (ClassloaderAdapterException classloaderAdapterException) {
            return false;
        }
        String[] stringArray = classLoaderAdapter.getClasspath(this, classLoader, true);
        if (stringArray == null) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray.length > 0) {
            stringBuffer.append(stringArray[0]);
        }
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuffer.append(';').append(stringArray[i]);
        }
        this.getProject().setProperty(this.property, stringBuffer.toString());
        return true;
    }

    public Object getAntProject() {
        return this.getProject();
    }

    public URLPath getClasspath() {
        return this.classpath;
    }

    public String[] getClasspathFiles() {
        return this.classpath.toPath().list();
    }

    public String[] getClasspathURLs() {
        return this.classpath.list();
    }

    public ClassLoaderHandler getHandler() {
        if (this.handler == null) {
            this.handler = this.getParameters().getDefaultHandler();
        }
        return this.handler;
    }

    public String getLoaderName() {
        if (this.loaderName == null) {
            this.loaderName = this.loader.getName();
        }
        return this.loaderName;
    }

    public ClassLoaderParameters getParameters() {
        if (this.parameters == null) {
            this.parameters = new AntLoaderParameters(this.getProject());
        }
        return this.parameters;
    }

    public ClassLoader getParentLoader() {
        if (this.parentLoader == null) {
            this.parentLoader = new LoaderRef(this.getProject(), "CORE");
            return null;
        }
        return this.parentLoader.getClassLoaderOrFallback(null, this.isFailOnError(), false);
    }

    public ClassLoader getSuperLoader() {
        if (this.superLoader == null) {
            return this.getClass().getClassLoader();
        }
        return this.superLoader.getClassLoaderOrFallback(null, this.isFailOnError(), false);
    }

    public boolean handleClasspathEntry(ClassLoader classLoader, String string) {
        if (!this.duplicateEntry.requiresCheck()) {
            return true;
        }
        if (!this.getUtil().containsEntry(this, classLoader, string)) {
            return true;
        }
        int n = this.duplicateEntry.getDuplicateLogLevel();
        if (n >= 0) {
            this.log("duplicate classpath entry: " + string, n);
        }
        return !this.duplicateEntry.isOmitDuplicate();
    }

    protected LoaderHandlerSet newHandlerSet() {
        LoaderHandlerSet loaderHandlerSet = new LoaderHandlerSet(this.getProject());
        loaderHandlerSet.addConfiguredHandler(this.getHandler());
        return loaderHandlerSet;
    }

    public void setClasspath(URLPath uRLPath) {
        if (this.classpath == null) {
            this.classpath = uRLPath;
        } else {
            this.classpath.append(uRLPath);
        }
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().addReference(reference);
    }

    public void setHandler(LoaderHandler loaderHandler) {
        loaderHandler.check();
        this.handler = loaderHandler;
    }

    public void setLoader(LoaderRef loaderRef) {
        if (loaderRef.isStandardLoader(3)) {
            throw new BuildException("attribute loader can not be 'none'");
        }
        this.loader = loaderRef;
    }

    public void setParameters(LoaderParameters loaderParameters) {
        this.parameters = loaderParameters;
    }

    public void setParentLoader(LoaderRef loaderRef) {
        this.parentLoader = loaderRef;
    }

    public void setProperty(String string) {
        this.property = string;
    }

    public void setReset(boolean bl) {
        this.reset = bl;
    }

    public void setSuperLoader(LoaderRef loaderRef) {
        this.parentLoader = loaderRef;
    }

    public static class DuplicateEntry
    extends EnumeratedAttribute {
        private static final int IGNORE = 0;
        private static final int WARN = 1;
        private static final int OMIT = 2;

        public DuplicateEntry() {
        }

        public DuplicateEntry(String string) {
            this.setValue(string);
        }

        public int getDuplicateLogLevel() {
            switch (this.getIndex()) {
                case 2: {
                    return 3;
                }
                case 1: {
                    return 1;
                }
            }
            return -1;
        }

        public String[] getValues() {
            return new String[]{"ignore", "warn", "omit"};
        }

        public boolean isOmitDuplicate() {
            return this.getIndex() != 2;
        }

        public boolean requiresCheck() {
            return this.getIndex() != 0;
        }
    }
}

