/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.classloader;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderAdapter;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderAdapterAction;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderHandler;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderHandlerSet;
import org.apache.tools.ant.taskdefs.classloader.ClassloaderAdapterException;
import org.apache.tools.ant.taskdefs.classloader.ClassloaderContext;
import org.apache.tools.ant.taskdefs.classloader.ClassloaderUtil;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReporter;

public final class SimpleClassloaderUtil
implements ClassloaderUtil {
    private static final int BUFFER_MULT = 50;
    private static final ClassloaderUtil SINGLETON = new SimpleClassloaderUtil();

    public static ClassloaderUtil getClassLoaderUtil() {
        return SINGLETON;
    }

    public boolean containsEntry(ClassloaderContext classloaderContext, ClassLoader classLoader, String string) {
        ArrayList arrayList = new ArrayList();
        if (SimpleClassloaderUtil.containsEntryDelegatedOrSelf(classloaderContext, classLoader, string, arrayList)) {
            return true;
        }
        if (arrayList.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer(50 * (1 + arrayList.size()));
            stringBuffer.append("Check for duplicate entries fails due to the following reason(s):");
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("\n").append(iterator.next());
            }
            classloaderContext.handleWarning(stringBuffer.toString());
        }
        return false;
    }

    private static boolean containsEntryDelegatedOrSelf(ClassloaderContext classloaderContext, ClassLoader classLoader, String string, List list) {
        if (classLoader == null) {
            URL[] uRLArray = classloaderContext.getUtil().getBootstrapClasspathURLs();
            if (uRLArray == null) {
                list.add("bootstrap classpath not investigatable");
                return false;
            }
            for (int i = 0; i < uRLArray.length; ++i) {
                if (!uRLArray[i].toString().equals(string)) continue;
                return true;
            }
            return false;
        }
        if (SimpleClassloaderUtil.containsEntrySelf(classloaderContext, classLoader, string, list)) {
            return true;
        }
        ClassLoaderAdapter classLoaderAdapter = classloaderContext.getUtil().findAdapter(classloaderContext, classLoader, null, list, "  parent of classloader " + classLoader.getClass().getModifiers(), "");
        ClassLoader classLoader2 = null;
        if (classLoaderAdapter != null && (classLoader2 = classLoaderAdapter.getParent(classLoader)) == null) {
            classLoader2 = classLoaderAdapter.getDefaultParent();
        }
        return SimpleClassloaderUtil.containsEntryDelegatedOrSelf(classloaderContext, classLoader2, string, list);
    }

    private static boolean containsEntrySelf(ClassloaderContext classloaderContext, ClassLoader classLoader, String string, List list) {
        ClassLoaderAdapter classLoaderAdapter = classloaderContext.getUtil().findAdapter(classloaderContext, classLoader, ClassLoaderAdapterAction.GETPATH, list, "path for classloader " + classLoader.getClass().getName(), "");
        if (classLoaderAdapter == null) {
            return false;
        }
        String[] stringArray = classLoaderAdapter.getClasspath(classloaderContext, classLoader, false);
        if (stringArray == null) {
            list.add("path for classloader " + classLoader.getClass().getName() + " not investigatable (adapter retrieves no path)");
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public ClassLoaderAdapter findAdapter(ClassloaderContext classloaderContext, ClassLoader classLoader, ClassLoaderAdapterAction classLoaderAdapterAction) throws ClassloaderAdapterException {
        ClassLoaderHandlerSet classLoaderHandlerSet = classloaderContext.getHandlerSet();
        if (classLoaderHandlerSet == null) {
            throw new ClassloaderAdapterException(0);
        }
        ClassLoaderHandler classLoaderHandler = classLoaderHandlerSet.getHandler(classloaderContext, classLoader, classLoaderAdapterAction);
        if (classLoaderHandler == null) {
            throw new ClassloaderAdapterException(1);
        }
        ClassLoaderAdapter classLoaderAdapter = classLoaderHandler.getAdapter(classloaderContext);
        if (classLoaderAdapter == null) {
            throw new ClassloaderAdapterException(2);
        }
        return classLoaderAdapter;
    }

    public ClassLoaderAdapter findAdapter(ClassloaderContext classloaderContext, ClassLoader classLoader, ClassLoaderAdapterAction classLoaderAdapterAction, ClassloaderReporter classloaderReporter, String string, String string2) {
        try {
            return this.findAdapter(classloaderContext, classLoader, classLoaderAdapterAction);
        }
        catch (ClassloaderAdapterException classloaderAdapterException) {
            switch (classloaderAdapterException.getReason()) {
                case 1: {
                    classloaderReporter.reportError(string + " not investigatable (no Loaderhandler found)" + string2);
                    break;
                }
                case 2: {
                    classloaderReporter.reportError(string + " not investigatable (Loaderhandler retrieves no adapter)" + string2);
                    break;
                }
                default: {
                    classloaderContext.handleError(string + " not investigatable (no Loaderhandlerset)" + string2, classloaderAdapterException);
                }
            }
            return null;
        }
    }

    public ClassLoaderAdapter findAdapter(ClassloaderContext classloaderContext, ClassLoader classLoader, ClassLoaderAdapterAction classLoaderAdapterAction, List list, String string, String string2) {
        try {
            return this.findAdapter(classloaderContext, classLoader, classLoaderAdapterAction);
        }
        catch (ClassloaderAdapterException classloaderAdapterException) {
            switch (classloaderAdapterException.getReason()) {
                case 1: {
                    list.add(string + " not investigatable (no Loaderhandler found)" + string2);
                    break;
                }
                case 2: {
                    list.add(string + " not investigatable (Loaderhandler retrieves no adapter)" + string2);
                    break;
                }
                default: {
                    classloaderContext.handleError(string + " not investigatable (no Loaderhandlerset)" + string2, classloaderAdapterException);
                }
            }
            return null;
        }
    }

    public URL[] getBootstrapClasspathURLs() {
        try {
            Object object = Class.forName("sun.misc.Launcher").getMethod("getBootstrapClassPath", null).invoke(null, null);
            return (URL[])object.getClass().getMethod("getURLs", null).invoke(object, null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private SimpleClassloaderUtil() {
    }
}

