/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.classloader.report;

public final class ClassloaderReportHandle
implements Comparable {
    private static final int BOOTSTRAP = 0;
    private static final int EXTENSION = 1;
    private static final int SYSTEM = 2;
    private static final int ANT_PROJECT = 3;
    private static final int ANT_CORE = 4;
    private static final int THREAD = 5;
    private static final int CURRENT = 6;
    public static final int ANT_REFERENCED = 7;
    public static final int ANT_DEFINED = 8;
    public static final int PARENT = 9;
    public static final int OTHER = 10;
    public static final ClassloaderReportHandle BOOTSTRAPHANDLE = new ClassloaderReportHandle(0, null);
    public static final ClassloaderReportHandle EXTENSIONHANDLE = new ClassloaderReportHandle(1, null);
    public static final ClassloaderReportHandle SYSTEMHANDLE = new ClassloaderReportHandle(2, null);
    public static final ClassloaderReportHandle PROJECTHANDLE = new ClassloaderReportHandle(3, null);
    public static final ClassloaderReportHandle COREHANDLE = new ClassloaderReportHandle(4, null);
    public static final ClassloaderReportHandle THREADHANDLE = new ClassloaderReportHandle(5, null);
    public static final ClassloaderReportHandle CURRENTHANDLE = new ClassloaderReportHandle(6, null);
    private static final String[] NAMES = new String[]{"Bootstrap Classloader", "Extension Classloader", "System Classloader", "Ant's Project Classloader", "Ant's CoreLoader", "ThreadContextClassloader of current thread", "Current Classloader", "Referenced as", "Loader for defined Task/Type", "Parent of", "other"};
    private String name;
    private int type;

    public ClassloaderReportHandle(int n, String string) {
        this.type = n;
        this.name = string;
    }

    public int compareTo(Object object) {
        if (object == this) {
            return 0;
        }
        ClassloaderReportHandle classloaderReportHandle = (ClassloaderReportHandle)object;
        if (this.type != classloaderReportHandle.type) {
            return this.type < classloaderReportHandle.type ? -1 : 1;
        }
        if (this.name == null != (classloaderReportHandle.name == null)) {
            return this.name == null ? -1 : 1;
        }
        return this.name == null ? 0 : this.name.compareTo(classloaderReportHandle.name);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        try {
            ClassloaderReportHandle classloaderReportHandle = (ClassloaderReportHandle)object;
            if (this.type != classloaderReportHandle.type) {
                return false;
            }
            if (this.name == null != (classloaderReportHandle.name == null)) {
                return false;
            }
            return this.name == null ? true : this.name.equals(classloaderReportHandle.name);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return NAMES[this.type];
    }

    public int hashCode() {
        if (this.name == null) {
            return this.type;
        }
        return this.type ^ this.name.hashCode();
    }

    public boolean isPopular() {
        return this.type <= 6;
    }

    public String toString() {
        if (this.name == null) {
            return this.getType();
        }
        return this.getType() + " " + this.getName();
    }
}

