/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.classloader.report;

import java.net.URL;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReportFormatter;
import org.apache.tools.ant.taskdefs.classloader.report.ClassloaderReportHandle;

public class ClassloaderReportTextFormatter
implements ClassloaderReportFormatter {
    private static final String PREFIX_ATTRIBUTES = "  - ";
    private static final String PREFIX_CHILDS = "  - ";
    private static final String PREFIX_CLASSLOADER = "  ";
    private static final String PREFIX_ENTRIES = "  - ";
    private static final String PREFIX_ERRORS = "  - ";
    private static final String PREFIX_PACKAGES = "  - ";
    private static final String PREFIX_REPORT = "";
    private static final String PREFIX_ROLES = "  - ";
    private static final String PREFIX_UNASSIGNED_ROLES = "  - ";

    public String beginAttributes(int n, String[] stringArray) {
        String string = stringArray[0] + "attributes: " + n + " entries";
        this.incPrefix(stringArray, "  - ");
        return string;
    }

    public String beginChildLoaders(int n, String[] stringArray) {
        String string = stringArray[0] + "childs:     " + n + " entries";
        this.incPrefix(stringArray, "  - ");
        return string;
    }

    public String beginClassloader(ClassloaderReportHandle classloaderReportHandle, String[] stringArray) {
        String string = stringArray[0] + "classloader: " + this.getRole(classloaderReportHandle);
        this.incPrefix(stringArray, PREFIX_CLASSLOADER);
        return string;
    }

    public String beginEntries(int n, String[] stringArray) {
        String string = stringArray[0] + "entries:    " + n + " entries";
        this.incPrefix(stringArray, "  - ");
        return string;
    }

    public String beginErrors(int n, String[] stringArray) {
        String string = stringArray[0] + "errors: " + n + " entries";
        this.incPrefix(stringArray, "  - ");
        return string;
    }

    public String beginPackages(int n, String[] stringArray) {
        String string = stringArray[0] + "packages:   " + n + " entries";
        this.incPrefix(stringArray, "  - ");
        return string;
    }

    public String beginReport(String[] stringArray) {
        String string = stringArray[0] + "classloaderreport";
        this.incPrefix(stringArray, PREFIX_REPORT);
        return string;
    }

    public String beginRoles(int n, String[] stringArray) {
        String string = stringArray[0] + "roles:      " + n + " entries";
        this.incPrefix(stringArray, "  - ");
        return string;
    }

    public String beginUnassignedRoles(int n, String[] stringArray) {
        String string = stringArray[0] + "unassigned roles: " + n + " entries";
        this.incPrefix(stringArray, "  - ");
        return string;
    }

    private void decPrefix(String[] stringArray, String string) {
        stringArray[0] = stringArray[0].substring(0, stringArray[0].length() - string.length());
    }

    public String endAttributes(int n, String[] stringArray) {
        this.decPrefix(stringArray, "  - ");
        return null;
    }

    public String endChildLoaders(int n, String[] stringArray) {
        this.decPrefix(stringArray, "  - ");
        return null;
    }

    public String endClassloader(ClassloaderReportHandle classloaderReportHandle, String[] stringArray) {
        this.decPrefix(stringArray, PREFIX_CLASSLOADER);
        return stringArray[0] + "----- end of " + this.getRole(classloaderReportHandle);
    }

    public String endEntries(int n, String[] stringArray) {
        this.decPrefix(stringArray, "  - ");
        return null;
    }

    public String endErrors(int n, String[] stringArray) {
        this.decPrefix(stringArray, "  - ");
        return null;
    }

    public String endPackages(int n, String[] stringArray) {
        this.decPrefix(stringArray, "  - ");
        return null;
    }

    public String endReport(String[] stringArray) {
        this.decPrefix(stringArray, PREFIX_REPORT);
        return stringArray[0] + "end of classloaderreport";
    }

    public String endRoles(int n, String[] stringArray) {
        this.decPrefix(stringArray, "  - ");
        return null;
    }

    public String endUnassignedRoles(int n, String[] stringArray) {
        this.decPrefix(stringArray, "  - ");
        return null;
    }

    public String formatAttribute(String string, String string2, String[] stringArray) {
        return stringArray[0] + string + " = " + string2;
    }

    public String formatChild(ClassloaderReportHandle classloaderReportHandle, String[] stringArray) {
        return stringArray[0] + this.getRole(classloaderReportHandle);
    }

    public String formatClass(Class clazz, String[] stringArray) {
        return stringArray[0] + "class:      " + clazz.getName();
    }

    public String formatEntry(String string, String string2, String[] stringArray) {
        return stringArray[0] + string + "=" + string2;
    }

    public String formatEntry(URL uRL, String[] stringArray) {
        return this.formatEntry("url", String.valueOf(uRL), stringArray);
    }

    public String formatError(String string, String[] stringArray) {
        return stringArray[0] + string;
    }

    public String formatExpliciteParent(ClassloaderReportHandle classloaderReportHandle, String[] stringArray) {
        return stringArray[0] + "parent:     " + this.getRole(classloaderReportHandle);
    }

    public String formatImpliciteParent(ClassloaderReportHandle classloaderReportHandle, String[] stringArray) {
        return stringArray[0] + "parent:     NULL (Default: " + this.getRole(classloaderReportHandle) + ")";
    }

    public String formatPackage(String string, String[] stringArray) {
        return stringArray[0] + string;
    }

    public String formatRole(ClassloaderReportHandle classloaderReportHandle, String[] stringArray) {
        return stringArray[0] + this.getRole(classloaderReportHandle);
    }

    public String formatUnassignedRole(ClassloaderReportHandle classloaderReportHandle, String[] stringArray) {
        return stringArray[0] + this.getRole(classloaderReportHandle);
    }

    private String getRole(ClassloaderReportHandle classloaderReportHandle) {
        return classloaderReportHandle.getType() + (classloaderReportHandle.getName() != null ? " " + classloaderReportHandle.getName() : PREFIX_REPORT);
    }

    private void incPrefix(String[] stringArray, String string) {
        stringArray[0] = stringArray[0] + string;
    }
}

