/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderAdapterAction;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderHandler;
import org.apache.tools.ant.taskdefs.classloader.ClassLoaderHandlerSet;
import org.apache.tools.ant.taskdefs.classloader.ClassloaderContext;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.LoaderHandler;
import org.apache.tools.ant.types.Reference;

public class LoaderHandlerSet
extends DataType
implements ClassLoaderHandlerSet {
    private boolean addDefault = true;
    private boolean addAll = false;
    private final ArrayList handlerList = new ArrayList();
    private final HashSet handlerSet = new HashSet();
    static /* synthetic */ Class class$org$apache$tools$ant$types$LoaderHandlerSet;

    private LoaderHandlerSet() {
    }

    public LoaderHandlerSet(Project project) {
        this.setProject(project);
        LoaderHandler.addPredefined(project);
    }

    public LoaderHandlerSet(Project project, Reference reference) {
        this(project);
        this.setRefid(reference);
    }

    public void addConfiguredHandler(ClassLoaderHandler classLoaderHandler) {
        this.checkChildrenAllowed();
        classLoaderHandler.check();
        if (this.handlerSet.add(classLoaderHandler.getLoader())) {
            this.handlerList.add(classLoaderHandler);
        }
    }

    public ClassLoaderHandler getHandler(ClassloaderContext classloaderContext, ClassLoader classLoader, ClassLoaderAdapterAction classLoaderAdapterAction) {
        int n;
        Object object;
        if (this.isReference()) {
            LoaderHandlerSet loaderHandlerSet = (LoaderHandlerSet)this.getCheckedRef(class$org$apache$tools$ant$types$LoaderHandlerSet == null ? (class$org$apache$tools$ant$types$LoaderHandlerSet = LoaderHandlerSet.class$("org.apache.tools.ant.types.LoaderHandlerSet")) : class$org$apache$tools$ant$types$LoaderHandlerSet, "loaderHandlerSet");
            return loaderHandlerSet.getHandler(classloaderContext, classLoader, classLoaderAdapterAction);
        }
        if (this.addAll) {
            object = LoaderHandler.getAllHandlers(this.getProject());
            for (n = 0; n < ((ClassLoaderHandler[])object).length; ++n) {
                this.addConfiguredHandler(object[n]);
            }
            this.addAll = false;
            this.addDefault = false;
        }
        if (this.addDefault) {
            object = LoaderHandler.getDefaultHandlers(this.getProject());
            for (n = 0; n < ((ClassLoaderHandler[])object).length; ++n) {
                this.addConfiguredHandler((ClassLoaderHandler)object[n]);
            }
            this.addDefault = false;
        }
        object = new ArrayList();
        HandlerHolder[] handlerHolderArray = this.handlerList.iterator();
        while (handlerHolderArray.hasNext()) {
            LoaderHandler loaderHandler = (LoaderHandler)handlerHolderArray.next();
            Class clazz = loaderHandler.getLoaderClass(classloaderContext, classLoader, classLoaderAdapterAction);
            if (clazz == null) continue;
            ((ArrayList)object).add(new HandlerHolder(loaderHandler, clazz));
        }
        if (((ArrayList)object).size() == 0) {
            classloaderContext.handleError("No Handler found for ClassLoader " + classLoader.getClass().getName() + " and action " + classLoaderAdapterAction);
            return null;
        }
        handlerHolderArray = ((ArrayList)object).toArray(new HandlerHolder[((ArrayList)object).size()]);
        for (int i = 1; i < handlerHolderArray.length; ++i) {
            boolean bl = false;
            for (int j = 0; !bl && j < i; ++j) {
                if (!handlerHolderArray[j].loaderClass.isAssignableFrom(handlerHolderArray[i].loaderClass)) continue;
                HandlerHolder handlerHolder = handlerHolderArray[i];
                System.arraycopy(handlerHolderArray, j, handlerHolderArray, j + 1, i - j);
                handlerHolderArray[j] = handlerHolder;
                bl = true;
            }
        }
        return handlerHolderArray[0].handler;
    }

    public void setAddDefault(boolean bl) {
        this.checkAttributesAllowed();
        this.addDefault = bl;
    }

    public void setAddAll(boolean bl) {
        this.checkAttributesAllowed();
        this.addAll = bl;
    }

    public void setHandler(LoaderHandler loaderHandler) {
        this.checkAttributesAllowed();
        loaderHandler.check();
        if (this.handlerSet.add(loaderHandler.getLoader())) {
            this.handlerList.add(loaderHandler);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class HandlerHolder {
        private final LoaderHandler handler;
        private final Class loaderClass;

        public HandlerHolder(LoaderHandler loaderHandler, Class clazz) {
            this.handler = loaderHandler;
            this.loaderClass = clazz;
        }
    }
}

