/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.URLUtils;

public class URLPath
extends DataType
implements Cloneable {
    private ArrayList elements;
    static /* synthetic */ Class class$java$util$Stack;
    static /* synthetic */ Class class$org$apache$tools$ant$Project;
    static /* synthetic */ Class class$org$apache$tools$ant$types$DataType;

    private static void addUnlessPresent(ArrayList arrayList, Set set, String string) {
        if (set.add(string)) {
            arrayList.add(string);
        }
    }

    private static String resolveURL(Project project, String string) {
        if (project != null) {
            try {
                return URLUtils.getURLUtils().resolve(string, project.getBaseDir());
            }
            catch (MalformedURLException malformedURLException) {
                return string;
            }
        }
        return string;
    }

    public URLPath(Project project) {
        this.setProject(project);
        this.elements = new ArrayList();
    }

    public URLPath(Project project, String string) {
        this(project);
        this.createPathElement().setPath(string);
    }

    public void addDirset(DirSet dirSet) {
        this.checkChildrenAllowed();
        this.elements.add(dirSet);
        this.setChecked(false);
    }

    public void addExisting(URLPath uRLPath) {
        this.addExisting(uRLPath, false);
    }

    public void addExisting(URLPath uRLPath, boolean bl) {
        String[] stringArray = uRLPath.list();
        File file = bl ? new File(System.getProperty("user.dir")) : null;
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = null;
            file2 = this.getProject() != null ? this.getProject().resolveFile(stringArray[i]) : new File(stringArray[i]);
            if (bl && !file2.exists()) {
                file2 = new File(file, stringArray[i]);
            }
            if (file2.exists()) {
                this.setLocation(file2.toString());
                continue;
            }
            this.log("dropping " + file2 + " from path as it doesn't exist", 3);
        }
    }

    public void addExtdirs(Path path) {
        String[] stringArray;
        this.checkChildrenAllowed();
        if (path == null) {
            stringArray = System.getProperty("java.ext.dirs");
            if (stringArray != null) {
                path = new Path(this.getProject(), (String)stringArray);
            } else {
                return;
            }
        }
        stringArray = path.list();
        for (int i = 0; i < stringArray.length; ++i) {
            File file = this.getProject().resolveFile(stringArray[i]);
            if (!file.exists() || !file.isDirectory()) continue;
            FileSet fileSet = new FileSet();
            fileSet.setDir(file);
            fileSet.setIncludes("*");
            this.addFileset(fileSet);
        }
    }

    public void addFilelist(FileList fileList) {
        this.checkChildrenAllowed();
        this.elements.add(fileList);
        this.setChecked(false);
    }

    public void addFileset(FileSet fileSet) {
        this.checkChildrenAllowed();
        this.elements.add(fileSet);
        this.setChecked(false);
    }

    public void addJavaRuntime() {
        this.createPath().addJavaRuntime();
    }

    public void addPath(Path path) {
        this.checkChildrenAllowed();
        this.elements.add(path);
        this.setChecked(false);
    }

    public void addReference(Reference reference) {
        this.checkChildrenAllowed();
        this.elements.add(reference);
        this.setChecked(false);
    }

    private Path addToPath(Path path) {
        if (path == null) {
            path = new Path(this.getProject());
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            Object object = this.elements.get(i);
            if (object instanceof Reference) {
                Reference reference = (Reference)object;
                object = reference.getReferencedObject(this.getProject());
            }
            if (object instanceof URLPathElement) {
                ((URLPathElement)object).addToPath(path);
                continue;
            }
            if (object instanceof URLPath) {
                ((URLPath)object).addToPath(path);
                continue;
            }
            if (object instanceof Path) {
                path.add((Path)object);
                continue;
            }
            if (object instanceof DirSet) {
                path.addDirset((DirSet)object);
                continue;
            }
            if (object instanceof FileSet) {
                path.addFileset((FileSet)object);
                continue;
            }
            if (!(object instanceof FileList)) continue;
            path.addFilelist((FileList)object);
        }
        return path;
    }

    private void addUnlessPresent(ArrayList arrayList, Set set, File file, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                String string = URLUtils.getURLUtils().resolve(stringArray[i], file);
                URLPath.addUnlessPresent(arrayList, set, string);
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                URLPath.addUnlessPresent(arrayList, set, stringArray[i]);
            }
        }
    }

    public void addURLPath(URLPath uRLPath) {
        this.checkChildrenAllowed();
        this.elements.add(uRLPath);
        this.setChecked(false);
    }

    public void append(URLPath uRLPath) {
        if (uRLPath == null) {
            return;
        }
        Iterator iterator = uRLPath.elements.iterator();
        while (iterator.hasNext()) {
            this.elements.add(iterator.next());
        }
        this.setChecked(false);
    }

    public Object clone() {
        try {
            URLPath uRLPath = (URLPath)super.clone();
            uRLPath.elements = (ArrayList)this.elements.clone();
            return uRLPath;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new BuildException((Throwable)cloneNotSupportedException);
        }
    }

    public URLPath concatSystemClasspath() {
        return this.concatSystemClasspath("last");
    }

    public URLPath concatSystemClasspath(String string) {
        String string2;
        URLPath uRLPath = new URLPath(this.getProject());
        String string3 = string;
        if (this.getProject() != null && (string2 = this.getProject().getProperty("build.sysclasspath")) != null) {
            string3 = string2;
        }
        if (string3.equals("only")) {
            uRLPath.addExisting(new URLPath(null, System.getProperty("java.class.path")), true);
        } else if (string3.equals("first")) {
            uRLPath.addExisting(new URLPath(null, System.getProperty("java.class.path")), true);
            uRLPath.addExisting(this);
        } else if (string3.equals("ignore")) {
            uRLPath.addExisting(this);
        } else {
            if (!string3.equals("last")) {
                this.log("invalid value for build.sysclasspath: " + string3, 1);
            }
            uRLPath.addExisting(this);
            uRLPath.addExisting(new URLPath(null, System.getProperty("java.class.path")), true);
        }
        return uRLPath;
    }

    public Path createPath() {
        this.checkChildrenAllowed();
        Path path = new Path(this.getProject());
        this.elements.add(path);
        this.setChecked(false);
        return path;
    }

    public Path.PathElement createPathElement() {
        this.checkChildrenAllowed();
        return this.createPath().createPathElement();
    }

    public URLPath createUrlpath() {
        this.checkChildrenAllowed();
        URLPath uRLPath = new URLPath(this.getProject());
        this.elements.add(uRLPath);
        this.setChecked(false);
        return uRLPath;
    }

    public URLPathElement createUrlpathelement() {
        this.checkChildrenAllowed();
        URLPathElement uRLPathElement = new URLPathElement();
        this.elements.add(uRLPathElement);
        return uRLPathElement;
    }

    public void dieOnCircularReference(Stack stack, Project project) throws BuildException {
        Method method;
        if (this.isChecked()) {
            return;
        }
        try {
            method = (class$org$apache$tools$ant$types$DataType == null ? (class$org$apache$tools$ant$types$DataType = URLPath.class$("org.apache.tools.ant.types.DataType")) : class$org$apache$tools$ant$types$DataType).getDeclaredMethod("dieOnCircularReference", class$java$util$Stack == null ? (class$java$util$Stack = URLPath.class$("java.util.Stack")) : class$java$util$Stack, class$org$apache$tools$ant$Project == null ? (class$org$apache$tools$ant$Project = URLPath.class$("org.apache.tools.ant.Project")) : class$org$apache$tools$ant$Project);
        }
        catch (SecurityException securityException) {
            throw new BuildException((Throwable)securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new BuildException("Possible Version Conflict, oata.types.DataType has no dieOnCircularReferenceMethod", (Throwable)noSuchMethodException);
        }
        method.setAccessible(true);
        Iterator iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            while (object instanceof Reference) {
                object = ((Reference)object).getReferencedObject(project);
            }
            if (!(object instanceof DataType)) continue;
            if (stack.contains(object)) {
                throw this.circularReference();
            }
            stack.push(object);
            try {
                method.invoke(object, stack, project);
            }
            catch (BuildException buildException) {
                throw buildException;
            }
            catch (Exception exception) {
                throw new BuildException((Throwable)exception);
            }
            stack.pop();
        }
        this.setChecked(true);
    }

    public String[] list() {
        ArrayList arrayList = new ArrayList(2 * this.elements.size());
        HashSet hashSet = new HashSet();
        for (int i = 0; i < this.elements.size(); ++i) {
            File file;
            Object object;
            Object object2 = this.elements.get(i);
            if (object2 instanceof Reference) {
                object = (String[])object2;
                object2 = object.getReferencedObject(this.getProject());
            }
            if (object2 instanceof URLPathElement) {
                object = ((URLPathElement)object2).getParts();
                if (object == null) {
                    throw new BuildException("You must either set location or path on <urlpathelement>");
                }
                for (int j = 0; j < ((Path)object).length; ++j) {
                    URLPath.addUnlessPresent(arrayList, hashSet, URLPath.resolveURL(this.getProject(), (String)object[j]));
                }
                continue;
            }
            if (object2 instanceof URLPath) {
                object = (URLPath)object2;
                if (object.getProject() == null) {
                    object.setProject(this.getProject());
                }
                String[] stringArray = object.list();
                for (int j = 0; j < stringArray.length; ++j) {
                    URLPath.addUnlessPresent(arrayList, hashSet, URLPath.resolveURL(object.getProject(), stringArray[j]));
                }
                continue;
            }
            if (object2 instanceof Path) {
                object = (String[])object2;
                if (object.getProject() == null) {
                    object.setProject(this.getProject());
                }
                String[] stringArray = object.list();
                for (int j = 0; j < stringArray.length; ++j) {
                    URLPath.addUnlessPresent(arrayList, hashSet, URLPath.resolveURL(object.getProject(), stringArray[j]));
                }
                continue;
            }
            if (object2 instanceof DirSet) {
                object = (DirSet)object2;
                DirectoryScanner directoryScanner = object.getDirectoryScanner(this.getProject());
                String[] stringArray = directoryScanner.getIncludedDirectories();
                file = object.getDir(this.getProject());
                this.addUnlessPresent(arrayList, hashSet, file, stringArray);
                continue;
            }
            if (object2 instanceof FileSet) {
                object = (FileSet)object2;
                DirectoryScanner directoryScanner = object.getDirectoryScanner(this.getProject());
                String[] stringArray = directoryScanner.getIncludedFiles();
                file = object.getDir(this.getProject());
                this.addUnlessPresent(arrayList, hashSet, file, stringArray);
                continue;
            }
            if (!(object2 instanceof FileList)) continue;
            object = (FileList)object2;
            String[] stringArray = object.getFiles(this.getProject());
            File file2 = object.getDir(this.getProject());
            this.addUnlessPresent(arrayList, hashSet, file2, stringArray);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void setLocation(String string) {
        this.checkAttributesAllowed();
        this.createUrlpathelement().setLocation(string);
    }

    public void setPath(String string) {
        this.checkAttributesAllowed();
        this.createPathElement().setPath(string);
    }

    public void setRefid(Reference reference) {
        if (!this.elements.isEmpty()) {
            throw this.tooManyAttributes();
        }
        this.elements.add(reference);
        super.setRefid(reference);
    }

    public void setUrlpath(String string) {
        this.checkAttributesAllowed();
        this.createUrlpathelement().setPath(string);
    }

    public int size() {
        return this.list().length;
    }

    public Path toPath() throws BuildException {
        return this.addToPath(null);
    }

    public String toString() {
        String[] stringArray = this.list();
        if (stringArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0].toString());
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuffer.append(';');
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public String translateFile(String string) {
        if (string == null) {
            return null;
        }
        try {
            if (!URLUtils.getURLUtils().isURL(string)) {
                string = this.getProject().resolveFile(string).getAbsolutePath();
            }
            return URLUtils.getURLUtils().resolve(string, this.getProject().getBaseDir());
        }
        catch (MalformedURLException malformedURLException) {
            return string;
        }
    }

    protected String[] translateUrlPath(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() <= 0 || (string2 = this.translateFile(string2)) == null) continue;
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class URLPathElement {
        private String[] parts = null;

        protected void addToPath(Path path) {
            if (this.parts == null) {
                return;
            }
            for (int i = 0; i < this.parts.length; ++i) {
                path.createPathElement().setLocation(URLUtils.getURLUtils().createFile(this.parts[i]));
            }
        }

        public String[] getParts() {
            return this.parts;
        }

        public void setLocation(String string) {
            if (this.parts != null) {
                throw new BuildException("either location or path can be defined");
            }
            if (string != null && (string = URLPath.this.translateFile(string)) != null) {
                this.parts = new String[]{string};
            }
        }

        public void setPath(String string) {
            if (this.parts != null) {
                throw new BuildException("either location or path can be defined");
            }
            this.parts = URLPath.this.translateUrlPath(string);
        }
    }
}

