/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Stack;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.classloader.ClassloaderURLUtil;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.util.FileUtils;

public final class URLUtils
implements ClassloaderURLUtil {
    private static final FileUtils FILEUTILS = FileUtils.newFileUtils();
    private static final boolean ON_NETWARE = Os.isFamily((String)"netware");
    private static URLUtils singleton = new URLUtils();

    public static URLUtils getURLUtils() {
        return singleton;
    }

    public File createFile(String string) {
        if (this.isURL(string)) {
            return new File(FILEUTILS.fromURI(string));
        }
        return new File(string);
    }

    public URL createURL(String string) throws MalformedURLException {
        if (this.isURL(string)) {
            return new URL(this.normalize(string));
        }
        return FILEUTILS.getFileURL(new File(string));
    }

    public boolean isAbsolute(String string) throws MalformedURLException {
        if (this.isURL(string)) {
            URL uRL = new URL(this.transformFileSep(string));
            String string2 = uRL.toString();
            if (uRL.getProtocol() != null) {
                string2 = string2.substring(uRL.getProtocol().length() + 1);
            }
            return string2.startsWith("/");
        }
        return new File(string).isAbsolute();
    }

    public boolean isFileOrFileURL(String string) {
        if (!this.isURL(string)) {
            return true;
        }
        return string.startsWith("file:");
    }

    public boolean isURL(String string) {
        String string2 = this.transformFileSep(string);
        if (string2.startsWith("/")) {
            return false;
        }
        try {
            URL uRL = new URL(this.transformFileSep(string));
            return uRL.getProtocol() != null;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    public String normalize(String string) throws MalformedURLException {
        CharSequence charSequence;
        if (!this.isURL(string)) {
            return FILEUTILS.normalize(string).toString();
        }
        String string2 = string;
        string = this.transformFileSep(string);
        string = new URL(string).toString();
        String string3 = string.substring(0, string.indexOf(58) + 1);
        string = string.substring(string3.length());
        while (string.startsWith("/")) {
            string3 = string3 + "/";
            string = string.substring(1);
        }
        int n = string.indexOf(58);
        if (n >= 0) {
            if (ON_NETWARE) {
                string3 = string3 + string.substring(0, n + 1);
                string = string.substring(n + 1);
            } else if (File.separatorChar == '\\' && File.pathSeparatorChar == ';' && n == 1 && Character.isLetter(string.charAt(0))) {
                string3 = string3 + string.substring(0, 2);
                string = string.substring(2);
            }
            while (string.startsWith("/")) {
                string3 = string3 + "/";
                string = string.substring(1);
            }
        }
        Stack<CharSequence> stack = new Stack<CharSequence>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            charSequence = stringTokenizer.nextToken();
            if (".".equals(charSequence)) continue;
            if ("..".equals(charSequence)) {
                if (stack.size() == 0) {
                    throw new BuildException("Cannot resolve path " + string2);
                }
                stack.pop();
                continue;
            }
            stack.push(charSequence);
        }
        charSequence = new StringBuffer(string.length());
        ((StringBuffer)charSequence).append(string3);
        boolean bl = true;
        Iterator iterator = stack.iterator();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            if (bl) {
                bl = false;
            } else {
                ((StringBuffer)charSequence).append('/');
            }
            ((StringBuffer)charSequence).append(string4);
        }
        if (string.endsWith("/") && ((StringBuffer)charSequence).charAt(((StringBuffer)charSequence).length() - 1) != '/') {
            ((StringBuffer)charSequence).append('/');
        }
        return ((StringBuffer)charSequence).toString();
    }

    public String resolve(String string, File file) throws MalformedURLException {
        if (this.isAbsolute(string)) {
            return this.createURL(string).toString();
        }
        if (!this.isFileOrFileURL(string)) {
            return string;
        }
        if (this.isURL(string)) {
            String string2 = FILEUTILS.fromURI(this.transformFileSep(string));
            return this.createURL(new File(file, string2).toString()).toString();
        }
        return this.createURL(new File(file, string).toString()).toString();
    }

    public String transformFileSep(String string) {
        return string.replace('\\', '/');
    }

    private URLUtils() {
    }
}

