/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables;

import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;

public class NetworkTableListenerAdapter
implements ITableListener {
    private final ITableListener targetListener;
    private final ITable targetSource;
    private final String prefix;

    public NetworkTableListenerAdapter(String prefix, ITable targetSource, ITableListener targetListener) {
        this.prefix = prefix;
        this.targetSource = targetSource;
        this.targetListener = targetListener;
    }

    @Override
    public void valueChanged(ITable source, String key, Object value, boolean isNew) {
        if (key.startsWith(this.prefix)) {
            String relativeKey = key.substring(this.prefix.length());
            if (NetworkTableListenerAdapter.contains(relativeKey, '/')) {
                return;
            }
            this.targetListener.valueChanged(this.targetSource, relativeKey, value, isNew);
        }
    }

    private static boolean contains(String source, char target) {
        for (int i = 0; i < source.length(); ++i) {
            if (source.charAt(i) != target) continue;
            return true;
        }
        return false;
    }
}

