/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables2;

import edu.wpi.first.wpilibj.networktables2.AbstractNetworkTableEntryStore;
import edu.wpi.first.wpilibj.networktables2.NetworkTableEntry;
import edu.wpi.first.wpilibj.networktables2.TableKeyExistsWithDifferentTypeException;
import edu.wpi.first.wpilibj.networktables2.client.ClientConnectionListenerManager;
import edu.wpi.first.wpilibj.networktables2.type.ComplexData;
import edu.wpi.first.wpilibj.networktables2.type.ComplexEntryType;
import edu.wpi.first.wpilibj.networktables2.type.DefaultEntryTypes;
import edu.wpi.first.wpilibj.networktables2.type.NetworkTableEntryType;
import edu.wpi.first.wpilibj.networktables2.util.List;
import edu.wpi.first.wpilibj.tables.IRemote;
import edu.wpi.first.wpilibj.tables.IRemoteConnectionListener;
import edu.wpi.first.wpilibj.tables.ITableListener;
import edu.wpi.first.wpilibj.tables.TableKeyNotDefinedException;

public abstract class NetworkTableNode
implements AbstractNetworkTableEntryStore.TableListenerManager,
ClientConnectionListenerManager,
IRemote {
    protected AbstractNetworkTableEntryStore entryStore;
    private final List remoteListeners = new List();
    private final List tableListeners = new List();

    protected final void init(AbstractNetworkTableEntryStore entryStore) {
        this.entryStore = entryStore;
    }

    public AbstractNetworkTableEntryStore getEntryStore() {
        return this.entryStore;
    }

    public void putBoolean(String name, boolean value) {
        this.putValue(name, DefaultEntryTypes.BOOLEAN, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getBoolean(String name) throws TableKeyNotDefinedException {
        NetworkTableEntry entry = this.entryStore.getEntry(name);
        if (entry == null) {
            throw new TableKeyNotDefinedException(name);
        }
        return (Boolean)entry.getValue();
    }

    public void putDouble(String name, double value) {
        this.putValue(name, DefaultEntryTypes.DOUBLE, new Double(value));
    }

    public double getDouble(String name) throws TableKeyNotDefinedException {
        NetworkTableEntry entry = this.entryStore.getEntry(name);
        if (entry == null) {
            throw new TableKeyNotDefinedException(name);
        }
        return (Double)entry.getValue();
    }

    public void putString(String name, String value) {
        this.putValue(name, DefaultEntryTypes.STRING, value);
    }

    public String getString(String name) throws TableKeyNotDefinedException {
        NetworkTableEntry entry = this.entryStore.getEntry(name);
        if (entry == null) {
            throw new TableKeyNotDefinedException(name);
        }
        return (String)entry.getValue();
    }

    public void putComplex(String name, ComplexData value) {
        this.putValue(name, value.getType(), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveValue(String name, Object externalData) throws TableKeyNotDefinedException {
        AbstractNetworkTableEntryStore abstractNetworkTableEntryStore = this.entryStore;
        synchronized (abstractNetworkTableEntryStore) {
            NetworkTableEntry entry = this.entryStore.getEntry(name);
            if (entry == null) {
                throw new TableKeyNotDefinedException(name);
            }
            NetworkTableEntryType entryType = entry.getType();
            if (!(entryType instanceof ComplexEntryType)) {
                throw new TableKeyExistsWithDifferentTypeException(name, entryType, "Is not a complex data type");
            }
            ComplexEntryType complexType = (ComplexEntryType)entryType;
            complexType.exportValue(name, entry.getValue(), externalData);
        }
    }

    public void putValue(String name, Object value) throws IllegalArgumentException {
        if (value instanceof Double) {
            this.putValue(name, DefaultEntryTypes.DOUBLE, value);
        } else if (value instanceof String) {
            this.putValue(name, DefaultEntryTypes.STRING, value);
        } else if (value instanceof Boolean) {
            this.putValue(name, DefaultEntryTypes.BOOLEAN, value);
        } else if (value instanceof ComplexData) {
            this.putValue(name, ((ComplexData)value).getType(), value);
        } else {
            if (value == null) {
                throw new NullPointerException("Cannot put a null value into networktables");
            }
            throw new IllegalArgumentException("Invalid Type");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putValue(String name, NetworkTableEntryType type, Object value) {
        if (type instanceof ComplexEntryType) {
            AbstractNetworkTableEntryStore abstractNetworkTableEntryStore = this.entryStore;
            synchronized (abstractNetworkTableEntryStore) {
                ComplexEntryType entryType = (ComplexEntryType)type;
                NetworkTableEntry entry = this.entryStore.getEntry(name);
                if (entry != null) {
                    this.entryStore.putOutgoing(entry, entryType.internalizeValue(entry.name, value, entry.getValue()));
                } else {
                    this.entryStore.putOutgoing(name, type, entryType.internalizeValue(name, value, null));
                }
            }
        } else {
            this.entryStore.putOutgoing(name, type, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putValue(NetworkTableEntry entry, Object value) {
        if (entry.getType() instanceof ComplexEntryType) {
            AbstractNetworkTableEntryStore abstractNetworkTableEntryStore = this.entryStore;
            synchronized (abstractNetworkTableEntryStore) {
                ComplexEntryType entryType = (ComplexEntryType)entry.getType();
                this.entryStore.putOutgoing(entry, entryType.internalizeValue(entry.name, value, entry.getValue()));
            }
        } else {
            this.entryStore.putOutgoing(entry, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(String name) throws TableKeyNotDefinedException {
        AbstractNetworkTableEntryStore abstractNetworkTableEntryStore = this.entryStore;
        synchronized (abstractNetworkTableEntryStore) {
            NetworkTableEntry entry = this.entryStore.getEntry(name);
            if (entry == null) {
                throw new TableKeyNotDefinedException(name);
            }
            return entry.getValue();
        }
    }

    public boolean containsKey(String key) {
        return this.entryStore.getEntry(key) != null;
    }

    public abstract void close();

    @Override
    public void addConnectionListener(IRemoteConnectionListener listener, boolean immediateNotify) {
        this.remoteListeners.add(listener);
        if (this.isConnected()) {
            listener.connected(this);
        } else {
            listener.disconnected(this);
        }
    }

    @Override
    public void removeConnectionListener(IRemoteConnectionListener listener) {
        this.remoteListeners.remove(listener);
    }

    @Override
    public void fireConnectedEvent() {
        for (int i = 0; i < this.remoteListeners.size(); ++i) {
            ((IRemoteConnectionListener)this.remoteListeners.get(i)).connected(this);
        }
    }

    @Override
    public void fireDisconnectedEvent() {
        for (int i = 0; i < this.remoteListeners.size(); ++i) {
            ((IRemoteConnectionListener)this.remoteListeners.get(i)).disconnected(this);
        }
    }

    public void addTableListener(ITableListener listener, boolean immediateNotify) {
        this.tableListeners.add(listener);
        if (immediateNotify) {
            this.entryStore.notifyEntries(null, listener);
        }
    }

    public void removeTableListener(ITableListener listener) {
        this.tableListeners.remove(listener);
    }

    @Override
    public void fireTableListeners(String key, Object value, boolean isNew) {
        for (int i = 0; i < this.tableListeners.size(); ++i) {
            ((ITableListener)this.tableListeners.get(i)).valueChanged(null, key, value, isNew);
        }
    }
}

