/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables2.type;

import edu.wpi.first.wpilibj.networktables2.type.ArrayEntryType;
import edu.wpi.first.wpilibj.networktables2.type.ComplexData;

public class ArrayData
extends ComplexData {
    private final ArrayEntryType type;
    private Object[] data = new Object[0];

    public ArrayData(ArrayEntryType type) {
        super(type);
        this.type = type;
    }

    protected Object getAsObject(int index) {
        return this.data[index];
    }

    protected void _set(int index, Object value) {
        this.data[index] = value;
    }

    protected void _add(Object value) {
        this.setSize(this.size() + 1);
        this.data[this.size() - 1] = value;
    }

    public void remove(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (index < this.size() - 1) {
            System.arraycopy(this.data, index + 1, this.data, index, this.size() - index - 1);
        }
        this.setSize(this.size() - 1);
    }

    public void setSize(int size) {
        if (size == this.data.length) {
            return;
        }
        Object[] newArray = new Object[size];
        if (size < this.data.length) {
            System.arraycopy(this.data, 0, newArray, 0, size);
        } else {
            System.arraycopy(this.data, 0, newArray, 0, this.data.length);
            for (int i = this.data.length; i < newArray.length; ++i) {
                newArray[i] = null;
            }
        }
        this.data = newArray;
    }

    public int size() {
        return this.data.length;
    }

    Object[] getDataArray() {
        return this.data;
    }
}

