/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables2.util;

import edu.wpi.first.wpilibj.networktables2.util.ResizeableArrayObject;

public class List
extends ResizeableArrayObject {
    protected int size = 0;

    public List() {
    }

    public List(int initialSize) {
        super(initialSize);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public void add(Object o) {
        this.ensureSize(this.size + 1);
        this.array[this.size++] = o;
    }

    public void remove(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (index < this.size - 1) {
            System.arraycopy(this.array, index + 1, this.array, index, this.size - index - 1);
        }
        --this.size;
    }

    public void clear() {
        this.size = 0;
    }

    public Object get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[index];
    }

    public boolean remove(Object object) {
        for (int i = 0; i < this.size; ++i) {
            Object value = this.array[i];
            if (!(object == null ? value == null : object.equals(value))) continue;
            this.remove(i);
            return true;
        }
        return false;
    }

    public boolean contains(Object object) {
        for (int i = 0; i < this.size; ++i) {
            Object value = this.array[i];
            if (!(object == null ? value == null : object.equals(value))) continue;
            return true;
        }
        return false;
    }

    public void set(int index, Object obj) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.array[index] = obj;
    }
}

